/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.googlecode.gentyref.GenericTypeReflector;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.util.ApiStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    public static final Object ANNOTATION_REFLECTION_LOCK = new Object();
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static boolean is(Type thisType, Class<?> ofThatType) {
        return ReflectionUtils.is(thisType, ofThatType, true);
    }

    public static boolean is(Type thisType, Class<?> ofThatType, boolean includeArray) {
        Class<?> thisClass = null;
        if (thisType instanceof Class) {
            thisClass = (Class<?>)thisType;
            if (includeArray && thisClass.isArray() && !ofThatType.isArray()) {
                if (ofThatType == Object.class) {
                    return true;
                }
                thisClass = thisClass.getComponentType();
            }
        }
        if (thisClass == ofThatType) {
            return true;
        }
        if (thisClass.isPrimitive() != ofThatType.isPrimitive()) {
            if (ReflectionUtils.isByte(thisClass) && ReflectionUtils.isByte(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isCharacter(thisClass) && ReflectionUtils.isCharacter(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isBoolean(thisClass) && ReflectionUtils.isBoolean(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isShort(thisClass) && ReflectionUtils.isShort(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isInteger(thisClass) && ReflectionUtils.isInteger(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isLong(thisClass) && ReflectionUtils.isLong(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isFloat(thisClass) && ReflectionUtils.isFloat(ofThatType)) {
                return true;
            }
            if (ReflectionUtils.isDouble(thisClass) && ReflectionUtils.isDouble(ofThatType)) {
                return true;
            }
        }
        return ofThatType.isAssignableFrom(thisClass);
    }

    public static boolean isCharacter(Type type) {
        return type == Character.TYPE || type == Character.class;
    }

    public static boolean isInputColumn(Class<?> type) {
        return ReflectionUtils.is(type, InputColumn.class);
    }

    public static boolean isColumn(Class<?> type) {
        return ReflectionUtils.is(type, Column.class);
    }

    public static boolean isTable(Class<?> type) {
        return ReflectionUtils.is(type, Table.class);
    }

    public static boolean isSchema(Class<?> type) {
        return ReflectionUtils.is(type, Schema.class);
    }

    public static boolean isCloseable(Class<?> type) {
        return ReflectionUtils.is(type, Closeable.class);
    }

    public static boolean isBoolean(Type type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isString(Type type) {
        return ReflectionUtils.is(type, String.class);
    }

    public static boolean isShort(Type type) {
        return type == Short.class || type == Short.TYPE;
    }

    public static boolean isDouble(Type type) {
        return type == Double.class || type == Double.TYPE;
    }

    public static boolean isLong(Type type) {
        return type == Long.class || type == Long.TYPE;
    }

    public static boolean isInteger(Type type) {
        return type == Integer.class || type == Integer.TYPE;
    }

    public static boolean isFloat(Type type) {
        return type == Float.class || type == Float.TYPE;
    }

    public static boolean isMap(Type type) {
        return type == Map.class;
    }

    public static boolean isSet(Type type) {
        return type == Set.class;
    }

    public static boolean isList(Type type) {
        return type == List.class;
    }

    public static boolean isDate(Type type) {
        return ReflectionUtils.is(type, Date.class, false);
    }

    public static boolean isNumber(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            boolean numberClass = ReflectionUtils.is(clazz, Number.class, false);
            if (numberClass) {
                return true;
            }
            return type == Byte.TYPE || type == Integer.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
        }
        return false;
    }

    public static boolean isByte(Type type) {
        return type == Byte.TYPE || type == Byte.class;
    }

    public static boolean isByteArray(Type type) {
        return type == byte[].class || type == Byte[].class;
    }

    public static String explodeCamelCase(String str, boolean excludeGetOrSet) {
        return ApiStringUtils.explodeCamelCase((String)str, (boolean)excludeGetOrSet);
    }

    public static int getTypeParameterCount(Field field) {
        Type genericType = field.getGenericType();
        return ReflectionUtils.getTypeParameterCount(genericType);
    }

    public static int getTypeParameterCount(Type genericType) {
        if (genericType instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)genericType;
            genericType = gaType.getGenericComponentType();
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            Type[] typeArguments = pType.getActualTypeArguments();
            return typeArguments.length;
        }
        return 0;
    }

    public static Class<?> getTypeParameter(Class<?> clazz, Class<?> genericInterface, int parameterIndex) {
        Type baseType = GenericTypeReflector.getExactSuperType(clazz, genericInterface);
        ParameterizedType pBaseType = (ParameterizedType)baseType;
        Type typeParameterForBaseInterface = pBaseType.getActualTypeArguments()[parameterIndex];
        return ReflectionUtils.getSafeClassToUse(typeParameterForBaseInterface);
    }

    public static Class<?> getTypeParameter(Type genericType, int parameterIndex) {
        if (genericType instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)genericType;
            genericType = gaType.getGenericComponentType();
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)genericType;
            Type[] typeArguments = ptype.getActualTypeArguments();
            if (typeArguments.length > parameterIndex) {
                Type argument = typeArguments[parameterIndex];
                return ReflectionUtils.getSafeClassToUse(argument);
            }
            throw new IllegalArgumentException("Only " + typeArguments.length + " parameters available");
        }
        return null;
    }

    public static Class<?> getTypeParameter(Field field, int parameterIndex) {
        Type genericType = field.getGenericType();
        return ReflectionUtils.getTypeParameter(genericType, parameterIndex);
    }

    public static boolean isWildcard(Type type) {
        return type instanceof WildcardType;
    }

    private static Class<?> getSafeClassToUse(Type someType) {
        if (someType instanceof GenericArrayType) {
            GenericArrayType gaType = (GenericArrayType)someType;
            someType = gaType.getGenericComponentType();
            return Array.newInstance((Class)someType, 0).getClass();
        }
        if (someType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)someType;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds != null && upperBounds.length > 0) {
                return (Class)upperBounds[0];
            }
            Type[] lowerBounds = wildcardType.getLowerBounds();
            if (lowerBounds != null && lowerBounds.length > 0) {
                return (Class)lowerBounds[0];
            }
        } else {
            if (someType instanceof Class) {
                return (Class)someType;
            }
            if (someType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)someType;
                return (Class)pType.getRawType();
            }
        }
        throw new UnsupportedOperationException("Parameter type not supported: " + someType);
    }

    public static int getHierarchyDistance(Class<?> subtype, Class<?> supertype) throws IllegalArgumentException {
        assert (subtype != null);
        assert (supertype != null);
        if (!ReflectionUtils.is(subtype, supertype)) {
            throw new IllegalArgumentException("Not a valid subtype of " + supertype.getName() + ": " + subtype.getName());
        }
        if (supertype.isInterface()) {
            return ReflectionUtils.getInterfaceHierarchyDistance(subtype, supertype);
        }
        return ReflectionUtils.getClassHierarchyDistance(subtype, supertype);
    }

    private static int getClassHierarchyDistance(Class<?> subtype, Class<?> supertype) {
        if (subtype == supertype) {
            return 0;
        }
        if (subtype == Object.class) {
            return Integer.MAX_VALUE;
        }
        Class<?> subSuperclass = subtype.getSuperclass();
        int distance = ReflectionUtils.getClassHierarchyDistance(subSuperclass, supertype);
        if (distance != Integer.MAX_VALUE) {
            return 1 + distance;
        }
        return Integer.MAX_VALUE;
    }

    private static int getInterfaceHierarchyDistance(Class<?> subtype, Class<?> supertype) {
        int distance;
        Class<?> subSuperclass;
        Class<?>[] interfaces;
        if (subtype == supertype) {
            return 0;
        }
        for (Class<?> i : interfaces = subtype.getInterfaces()) {
            if (i != supertype) continue;
            return 1;
        }
        int bestCandidate = Integer.MAX_VALUE;
        if (!subtype.isInterface() && (subSuperclass = subtype.getSuperclass()) != null && (distance = ReflectionUtils.getInterfaceHierarchyDistance(subSuperclass, supertype)) != Integer.MAX_VALUE) {
            int candidate = 1 + distance;
            bestCandidate = Math.min(bestCandidate, candidate);
        }
        for (Class<?> i : interfaces) {
            Class<?>[] subInterfaces = i.getInterfaces();
            if (subInterfaces == null || subInterfaces.length <= 0) continue;
            for (Class<?> subInterface : subInterfaces) {
                int distance2 = ReflectionUtils.getInterfaceHierarchyDistance(subInterface, supertype);
                if (distance2 == Integer.MAX_VALUE) continue;
                int candidate = 1 + distance2;
                bestCandidate = Math.min(bestCandidate, candidate);
            }
        }
        return bestCandidate;
    }

    public static boolean isArray(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().isArray();
    }

    public static Method[] getMethods(Class<?> clazz, Class<? extends Annotation> withAnnotation) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = ReflectionUtils.getMethods(clazz)) {
            if (!ReflectionUtils.isAnnotationPresent(method, withAnnotation)) continue;
            result.add(method);
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Field[] getAllFields(Class<?> clazz, Class<? extends Annotation> withAnnotation) {
        Field[] fields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : fields = ReflectionUtils.getAllFields(clazz)) {
            if (!ReflectionUtils.isAnnotationPresent(field, withAnnotation)) continue;
            result.add(field);
        }
        return result.toArray(new Field[result.size()]);
    }

    public static Method getMethod(Class<?> clazz, String name) {
        return ReflectionUtils.getMethod(clazz, name, false);
    }

    public static Method getMethod(Class<?> clazz, String name, boolean withParameters) {
        if (clazz == Object.class || clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(name, new Class[0]);
            return method;
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            if (withParameters) {
                Method[] methods;
                for (Method method : methods = ReflectionUtils.getMethods(clazz)) {
                    if (!name.equals(method.getName())) continue;
                    return method;
                }
                return null;
            }
            return ReflectionUtils.getMethod(clazz.getSuperclass(), name, withParameters);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (clazz == Object.class || clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchFieldException e) {
            return ReflectionUtils.getField(clazz.getSuperclass(), fieldName);
        }
    }

    @Deprecated
    public static boolean isGetMethodsLegacyApproach() {
        return false;
    }

    public static Method[] getMethods(Class<?> clazz) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        ReflectionUtils.addMethods(allMethods, clazz);
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    private static void addMethods(List<Method> allMethods, Class<?> clazz) {
        Method[] methods;
        if (clazz == Object.class || clazz == null) {
            return;
        }
        for (Method method : methods = clazz.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class) continue;
            allMethods.add(method);
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        ReflectionUtils.addFields(allFields, clazz);
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static Field[] getNonSyntheticFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ReflectionUtils.addFields(fieldList, clazz, true);
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    private static void addFields(List<Field> allFields, Class<?> clazz) {
        ReflectionUtils.addFields(allFields, clazz, false);
    }

    private static void addFields(List<Field> allFields, Class<?> clazz, boolean excludeSynthetic) {
        Field[] f;
        if (clazz == Object.class) {
            return;
        }
        for (Field field : f = clazz.getDeclaredFields()) {
            if (excludeSynthetic && field.isSynthetic()) continue;
            allFields.add(field);
        }
        Class<?> superclass = clazz.getSuperclass();
        ReflectionUtils.addFields(allFields, superclass, excludeSynthetic);
    }

    public static <E> E newInstance(Class<? extends E> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            logger.warn("Could not instantiate {}: {}", clazz, (Object)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    public static <A extends Annotation> A getAnnotation(Enum<?> enumConstant, Class<A> annotationClass) {
        try {
            Field field = enumConstant.getClass().getDeclaredField(enumConstant.name());
            return ReflectionUtils.getAnnotation(field, annotationClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        Object object = ANNOTATION_REFLECTION_LOCK;
        synchronized (object) {
            A annotation = element.getAnnotation(annotationClass);
            if (annotation == null && element instanceof Method) {
                Class<?>[] interfaces;
                Method m = (Method)element;
                Class<?> declaringClass = m.getDeclaringClass();
                Class<?> superClass = declaringClass.getSuperclass();
                String methodName = m.getName();
                Class<?>[] methodParameterTypes = m.getParameterTypes();
                if (superClass != null) {
                    try {
                        Method overriddenMethod = superClass.getMethod(methodName, methodParameterTypes);
                        return ReflectionUtils.getAnnotation(overriddenMethod, annotationClass);
                    }
                    catch (NoSuchMethodException e) {
                        logger.debug("Failed to get overridden method '{}' from {}", (Object)methodName, superClass);
                    }
                }
                for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                    try {
                        Method overriddenMethod = interfaceClass.getMethod(methodName, methodParameterTypes);
                        return ReflectionUtils.getAnnotation(overriddenMethod, annotationClass);
                    }
                    catch (NoSuchMethodException e) {
                        logger.debug("Failed to get overridden method '{}' from {}", (Object)methodName, interfaceClass);
                    }
                }
            }
            return annotation;
        }
    }

    public static boolean isAnnotationPresent(Enum<?> enumConstant, Class<? extends Annotation> annotationClass) {
        try {
            Field field = enumConstant.getClass().getDeclaredField(enumConstant.name());
            return ReflectionUtils.isAnnotationPresent(field, annotationClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return ReflectionUtils.getAnnotation(element, annotationClass) != null;
    }
}

