/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.datacleaner.extensions.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);
    private static ResourceManager instance = new ResourceManager();

    public static ResourceManager get() {
        return instance;
    }

    @Deprecated
    public static ResourceManager getInstance() {
        return ResourceManager.get();
    }

    private ResourceManager() {
    }

    public List<URL> getUrls(String path, ClassLoader ... classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            classLoaders = ClassLoaderUtils.getParentClassLoader().equals(this.getClass().getClassLoader()) ? new ClassLoader[]{ClassLoaderUtils.getParentClassLoader()} : new ClassLoader[]{ClassLoaderUtils.getParentClassLoader(), this.getClass().getClassLoader()};
        } else if (logger.isDebugEnabled()) {
            logger.debug("Custom classloaders specified: {}", (Object)Arrays.toString(classLoaders));
        }
        LinkedList<URL> result = new LinkedList<URL>();
        URL url = this.getClass().getResource(path);
        if (url != null) {
            result.add(url);
        }
        try {
            for (ClassLoader classLoader : classLoaders) {
                Enumeration<URL> resources = classLoader.getResources(path);
                while (resources.hasMoreElements()) {
                    URL element = resources.nextElement();
                    if (element == null) {
                        logger.warn("ClassLoader {} returned a null URL resource for path '{}'", (Object)classLoader, (Object)path);
                        continue;
                    }
                    result.add(element);
                }
            }
        }
        catch (IOException e) {
            logger.error("IOException when investigating classloader resources", (Throwable)e);
        }
        File file = new File("src/main/resources/" + path);
        if (file.exists()) {
            try {
                result.add(file.toURI().toURL());
            }
            catch (IOException e) {
                logger.error("IOException when adding File-based resource to URLs", (Throwable)e);
            }
        }
        return result;
    }

    public URL getUrl(String path, ClassLoader ... classLoaders) {
        List<URL> urls = this.getUrls(path, classLoaders);
        if (urls.isEmpty()) {
            return null;
        }
        return urls.get(0);
    }
}

