/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.datacleaner.util.ReflectionUtils;

public class VFSUtils {
    public static FileSystemManager getFileSystemManager() {
        try {
            FileSystemManager manager = VFS.getManager();
            if (manager.getBaseFile() == null) {
                ((DefaultFileSystemManager)manager).setBaseFile(new File("."));
            }
            return manager;
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public static FileSystem getBaseFileSystem() {
        try {
            return VFSUtils.getFileSystemManager().getBaseFile().getFileSystem();
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public static FileObject toFileObject(File file) {
        if (file == null) {
            return null;
        }
        try {
            return VFSUtils.getFileSystemManager().toFileObject(file);
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File toFile(FileObject fileObject) {
        if (fileObject instanceof LocalFile) {
            Method method = ReflectionUtils.getMethod(LocalFile.class, "getLocalFile");
            try {
                method.setAccessible(true);
                Object result = method.invoke((Object)fileObject, new Object[0]);
                return (File)result;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

