/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(VfsResource.class);
    private final FileObject _fileObject;

    public VfsResource(FileObject fileObject) {
        this._fileObject = fileObject;
    }

    public String toString() {
        return "VfsResource[" + this._fileObject + "]";
    }

    public FileObject getFileObject() {
        return this._fileObject;
    }

    public String getName() {
        return this._fileObject.getName().getBaseName();
    }

    public boolean isReadOnly() {
        try {
            return !this._fileObject.isWriteable();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public boolean isExists() {
        try {
            return this._fileObject.exists();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public String getQualifiedPath() {
        return this._fileObject.getName().getURI();
    }

    public long getSize() {
        try {
            return this._fileObject.getContent().getSize();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public long getLastModified() {
        try {
            long lastModified = this._fileObject.getContent().getLastModifiedTime();
            if (lastModified == 0L) {
                return -1L;
            }
            return lastModified;
        }
        catch (FileSystemException e) {
            logger.warn("Failed to get lastModifiedTime of file object: " + this._fileObject + ". Returning -1.", (Throwable)e);
            return -1L;
        }
    }

    public InputStream read() throws ResourceException {
        try {
            return this._fileObject.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public OutputStream append() throws ResourceException {
        try {
            FileContent content = this._fileObject.getContent();
            OutputStream out = content.getOutputStream(true);
            return out;
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    public OutputStream write() throws ResourceException {
        try {
            FileContent content = this._fileObject.getContent();
            OutputStream out = content.getOutputStream();
            return out;
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }
}

