/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.batch;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

final class BatchEntry<I, O> {
    private final I _input;
    private final CountDownLatch _countDownLatch;
    private volatile O _output;

    public BatchEntry(I input) {
        this._input = input;
        this._countDownLatch = new CountDownLatch(1);
    }

    public I getInput() {
        return this._input;
    }

    public O getOuput() {
        return this._output;
    }

    public void setOutput(O output) {
        this._output = output;
        this._countDownLatch.countDown();
    }

    public boolean await(long waitMillis) throws InterruptedException {
        return this._countDownLatch.await(waitMillis, TimeUnit.MILLISECONDS);
    }
}

