/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.batch;

import java.util.Collection;
import javax.inject.Inject;
import org.datacleaner.api.Close;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Provided;
import org.datacleaner.api.Transformer;
import org.datacleaner.util.batch.BatchTransformation;
import org.datacleaner.util.batch.BatchTransformationBuffer;

public abstract class BatchRowCollectingTransformer
implements Transformer,
BatchTransformation<InputRow, Collection<Object[]>> {
    @Provided
    @Inject
    OutputRowCollector outputRowCollector;
    private final BatchTransformationBuffer<InputRow, Collection<Object[]>> _batchTransformationBuffer = new BatchTransformationBuffer<InputRow, Collection<Object[]>>(this, this.getMaxBatchSize(), this.getFlushIntervalMillis());

    protected int getFlushIntervalMillis() {
        return 1000;
    }

    protected int getMaxBatchSize() {
        return 20;
    }

    @Initialize
    public final void initialize() {
        this._batchTransformationBuffer.start();
    }

    @Close
    public final void close() {
        this._batchTransformationBuffer.shutdown();
    }

    public final Object[] transform(InputRow inputRow) {
        Collection<Object[]> outputRows = this._batchTransformationBuffer.transform(inputRow);
        for (Object[] row : outputRows) {
            this.outputRowCollector.putValues(row);
        }
        return null;
    }
}

