/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.datacleaner.api.Convertable;
import org.datacleaner.api.Converter;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.lifecycle.MemberInjectionPoint;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.ArrayConverter;
import org.datacleaner.util.convert.MapStringToStringConverter;
import org.datacleaner.util.convert.NullConverter;
import org.datacleaner.util.convert.SerializationStringEscaper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingConverter
implements Converter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingConverter.class);
    private final List<Converter<?>> _converters = new ArrayList();
    private final NullConverter _nullConverter = new NullConverter();
    private final ArrayConverter _arrayConverter = new ArrayConverter(this);
    private final MapStringToStringConverter _mapStringToStringConverter = new MapStringToStringConverter();

    public DelegatingConverter() {
        this(null);
    }

    public DelegatingConverter(Collection<Converter<?>> converters) {
        if (converters != null) {
            this._converters.addAll(converters);
        }
    }

    public List<Converter<?>> getConverters() {
        return this._converters;
    }

    public void addConverter(Converter<?> converter) {
        this._converters.add(converter);
    }

    public Object fromString(Class<?> type, String serializedForm) {
        if (type == null || serializedForm == null || this._nullConverter.isNull(serializedForm)) {
            return this._nullConverter.fromString(type, serializedForm);
        }
        if (type.isArray()) {
            return this._arrayConverter.fromString(type, serializedForm);
        }
        serializedForm = SerializationStringEscaper.unescape(serializedForm);
        for (Converter<?> converter : this._converters) {
            if (!converter.isConvertable(type)) continue;
            Object result = converter.fromString(type, serializedForm);
            return result;
        }
        if (ReflectionUtils.is(type, List.class)) {
            return this._arrayConverter.fromString(type, serializedForm);
        }
        if (ReflectionUtils.is(type, Map.class)) {
            return this._mapStringToStringConverter.fromString((Class)type, serializedForm);
        }
        Convertable convertable = ReflectionUtils.getAnnotation(type, Convertable.class);
        if (convertable != null) {
            try {
                Class converterClass = convertable.value();
                Converter converter = (Converter)ReflectionUtils.newInstance(converterClass);
                return converter.fromString(type, serializedForm);
            }
            catch (Exception e) {
                logger.warn("Failed to convert fromString(" + serializedForm + ") using Convertable annotated converter class", (Throwable)e);
            }
        }
        throw new IllegalStateException("Could not find matching converter for type: " + type);
    }

    public String toString(Object instance) {
        if (null == instance) {
            return this._nullConverter.toString(instance);
        }
        Class<?> type = instance.getClass();
        if (this._arrayConverter.isConvertable(type)) {
            return this._arrayConverter.toString(instance);
        }
        if (this._mapStringToStringConverter.isConvertable(type)) {
            return this._mapStringToStringConverter.toString((Map)instance);
        }
        for (Converter<?> converter : this._converters) {
            if (!converter.isConvertable(type)) continue;
            Converter<?> castedConverter = converter;
            String serializedForm = castedConverter.toString(instance);
            return SerializationStringEscaper.escape(serializedForm);
        }
        Convertable convertable = ReflectionUtils.getAnnotation(instance.getClass(), Convertable.class);
        if (convertable != null) {
            try {
                Class converterClass = convertable.value();
                Converter converter = (Converter)ReflectionUtils.newInstance(converterClass);
                return SerializationStringEscaper.escape(converter.toString(instance));
            }
            catch (Exception e) {
                logger.warn("Failed to convert toString(" + instance + ") using Convertable annotated converter class", (Throwable)e);
            }
        }
        throw new IllegalStateException("Could not find matching converter for instance: " + instance);
    }

    public boolean isConvertable(Class<?> instance) {
        return true;
    }

    public void initializeAll(InjectionManager injectionManager) {
        for (Converter<?> converter : this._converters) {
            this.initialize(converter, injectionManager);
        }
    }

    public void initialize(Converter<?> converter, InjectionManager injectionManager) {
        if (injectionManager != null) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getAllFields(converter.getClass(), Inject.class)) {
                Object value;
                if (field.getType() == Converter.class) {
                    value = this;
                } else {
                    MemberInjectionPoint injectionPoint = new MemberInjectionPoint(field, converter);
                    value = injectionManager.getInstance(injectionPoint);
                }
                field.setAccessible(true);
                try {
                    field.set(converter, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not initialize converter: " + converter, e);
                }
            }
        }
    }
}

