/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.datacleaner.api.Converter;

public class EncodedStringConverter
implements Converter<String> {
    private static final String ALGORHITM = "PBEWithMD5AndDES";
    private static final byte[] DEFAULT_SALT = new byte[]{-34, 51, 18, 16, 51, 16, 18, -34};
    private static final char[] DEFAULT_SECRET = "cafelattebabemlobhat".toCharArray();
    private final byte[] _salt;
    private final char[] _secret;

    public EncodedStringConverter() {
        this(DEFAULT_SALT, DEFAULT_SECRET);
    }

    public EncodedStringConverter(byte[] salt, char[] secret) {
        this._salt = salt;
        this._secret = secret;
    }

    public String fromString(Class<?> type, String encodedPassword) {
        if (encodedPassword == null) {
            return null;
        }
        try {
            SecretKeyFactory instance = SecretKeyFactory.getInstance(ALGORHITM);
            SecretKey key = instance.generateSecret(new PBEKeySpec(this._secret));
            Cipher cipher = Cipher.getInstance(ALGORHITM);
            cipher.init(2, (Key)key, new PBEParameterSpec(this._salt, 20));
            byte[] bytes = encodedPassword.getBytes("UTF-8");
            bytes = cipher.doFinal(Base64.decodeBase64((byte[])bytes));
            return new String(bytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to decode password", e);
        }
    }

    public String toString(String password) {
        if (password == null) {
            return null;
        }
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORHITM);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this._secret));
            Cipher pbeCipher = Cipher.getInstance(ALGORHITM);
            pbeCipher.init(1, (Key)key, new PBEParameterSpec(this._salt, 20));
            byte[] bytes = pbeCipher.doFinal(password.getBytes());
            bytes = Base64.encodeBase64((byte[])bytes, (boolean)false);
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to encode password", e);
        }
    }

    public boolean isConvertable(Class<?> type) {
        return String.class.equals(type);
    }
}

