/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.io.File;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.util.FileResolver;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.ResourceConverter;

public class FileResourceTypeHandler
implements ResourceConverter.ResourceTypeHandler<FileResource> {
    public static final String DEFAULT_SCHEME = "file";
    private final String _scheme;
    private final File _homeFolder;

    @Deprecated
    public FileResourceTypeHandler() {
        this(DataCleanerConfigurationImpl.defaultHomeFolder());
    }

    public FileResourceTypeHandler(DataCleanerConfiguration configuration) {
        this(configuration.getHomeFolder());
    }

    public FileResourceTypeHandler(DataCleanerHomeFolder homeFolder) {
        this(homeFolder.toFile());
    }

    public FileResourceTypeHandler(File relativeParentDirectory) {
        this(DEFAULT_SCHEME, relativeParentDirectory);
    }

    public FileResourceTypeHandler(String scheme, File relativeParentDirectory) {
        this._scheme = scheme;
        this._homeFolder = relativeParentDirectory;
    }

    @Override
    public boolean isParserFor(Class<? extends Resource> resourceType) {
        return ReflectionUtils.is(resourceType, FileResource.class);
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    public FileResource parsePath(String path) {
        FileResolver fileResolver = new FileResolver(this._homeFolder);
        File file = fileResolver.toFile(path);
        return new FileResource(file);
    }

    @Override
    public String createPath(Resource resource) {
        File file = ((FileResource)resource).getFile();
        FileResolver fileResolver = new FileResolver(this._homeFolder);
        return fileResolver.toPath(file);
    }
}

