/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.datacleaner.configuration.ServerInformationCatalog;
import org.datacleaner.server.HadoopClusterInformation;
import org.datacleaner.util.HadoopResource;

public class HadoopResourceBuilder {
    private final URI _uri;
    private final String _clusterReferenceName;
    private final Configuration _configuration;
    public static final Pattern RESOURCE_SCHEME_PATTERN = Pattern.compile("([\\w\\+\\-\\.]+)://\\{([\\w\\.\\W\\s]*)\\}(.*)");

    public HadoopResourceBuilder(ServerInformationCatalog catalog, String templatedUri) {
        Matcher matcher = RESOURCE_SCHEME_PATTERN.matcher(templatedUri);
        if (!matcher.matches()) {
            this._clusterReferenceName = null;
            String fixedUri = templatedUri.replace(" ", "%20");
            HadoopClusterInformation hadoopClusterInformation = (HadoopClusterInformation)catalog.getServer("org.datacleaner.hadoop.environment");
            this._configuration = hadoopClusterInformation != null ? hadoopClusterInformation.getConfiguration() : new Configuration();
            this._configuration.set("fs.defaultFS", fixedUri);
            this._uri = URI.create(fixedUri);
        } else {
            this._clusterReferenceName = matcher.group(2);
            HadoopClusterInformation hadoopClusterInformation = (HadoopClusterInformation)catalog.getServer(this._clusterReferenceName);
            this._configuration = hadoopClusterInformation.getConfiguration();
            this._uri = URI.create(matcher.group(3).replace(" ", "%20"));
        }
    }

    public HadoopResource build() {
        return new HadoopResource(this._uri, this._configuration, this._clusterReferenceName);
    }
}

