/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import org.apache.metamodel.util.HdfsResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.util.HadoopResource;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.HadoopResourceBuilder;
import org.datacleaner.util.convert.ResourceConverter;

public class HdfsResourceTypeHandler
implements ResourceConverter.ResourceTypeHandler<HadoopResource> {
    private final String _scheme;
    private final DataCleanerConfiguration _dataCleanerConfiguration;

    public HdfsResourceTypeHandler() {
        this("hdfs");
    }

    public HdfsResourceTypeHandler(String scheme) {
        this(scheme, new DataCleanerConfigurationImpl());
    }

    public HdfsResourceTypeHandler(String scheme, DataCleanerConfiguration dataCleanerConfiguration) {
        this._scheme = scheme;
        this._dataCleanerConfiguration = dataCleanerConfiguration;
    }

    @Override
    public boolean isParserFor(Class<? extends Resource> resourceType) {
        return ReflectionUtils.is(resourceType, HdfsResource.class);
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    public HadoopResource parsePath(String path) {
        String prefix = this.getScheme() + "://";
        if (!path.startsWith(prefix)) {
            path = prefix + path;
        }
        HadoopResourceBuilder builder = new HadoopResourceBuilder(this._dataCleanerConfiguration.getServerInformationCatalog(), path);
        return builder.build();
    }

    @Override
    public String createPath(Resource resource) {
        String prefix = this.getScheme() + "://";
        String path = resource.getQualifiedPath();
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        return path;
    }
}

