/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvWriter;
import org.datacleaner.api.Converter;
import org.datacleaner.util.ReflectionUtils;

public class MapStringToStringConverter
implements Converter<Map<?, ?>> {
    private final CsvConfiguration configuration = new CsvConfiguration(1, "UTF-8", '=', '\"', '\\');

    public Map<?, ?> fromString(Class<?> type, String serializedForm) {
        try {
            CSVParser csvParser = new CSVParser(this.configuration.getSeparatorChar(), this.configuration.getQuoteChar(), this.configuration.getEscapeChar());
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Iterable lines = Splitter.on((char)'\n').split((CharSequence)serializedForm);
            for (String line : lines) {
                String[] values = csvParser.parseLine(line);
                if (values.length != 2) continue;
                String value = values[1];
                if ("<null>".equals(value)) {
                    value = null;
                }
                map.put(values[0], value);
            }
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(Map<?, ?> instance) {
        CsvWriter csvWriter = new CsvWriter(this.configuration);
        StringBuilder sb = new StringBuilder();
        Set<?> keys = instance.keySet();
        for (Object key : keys) {
            Object value = instance.get(key);
            String valueStr = Objects.toString(value, "<null>");
            String keyStr = Objects.toString(key, "<null>");
            String line = csvWriter.buildLine(new String[]{keyStr, valueStr});
            sb.append(line);
        }
        return sb.toString();
    }

    public boolean isConvertable(Class<?> type) {
        return ReflectionUtils.is(type, Map.class);
    }
}

