/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import org.apache.metamodel.util.Resource;
import org.datacleaner.repository.Repository;
import org.datacleaner.repository.RepositoryFileResource;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.ResourceConverter;

public class RepositoryFileResourceTypeHandler
implements ResourceConverter.ResourceTypeHandler<RepositoryFileResource> {
    private final Repository _repository;
    private final RepositoryFolder _homeFolder;

    public RepositoryFileResourceTypeHandler(Repository repository, RepositoryFolder homeFolder) {
        this._repository = repository;
        this._homeFolder = homeFolder;
    }

    public RepositoryFileResourceTypeHandler(Repository repository, String tenantId) {
        this._repository = repository;
        this._homeFolder = repository.getFolder(tenantId);
    }

    @Override
    public boolean isParserFor(Class<? extends Resource> cls) {
        return ReflectionUtils.is(cls, RepositoryFileResource.class);
    }

    @Override
    public String createPath(Resource resource) {
        String prefix;
        RepositoryFileResource repositoryFileResource = (RepositoryFileResource)resource;
        String qualifiedPath = repositoryFileResource.getQualifiedPath();
        if (!qualifiedPath.startsWith(prefix = this.getHomeFolderPrefix())) {
            throw new IllegalArgumentException("This RepositoryFileResourceTypeHandler can only handle repository file from home '" + prefix + "'. Got: " + qualifiedPath);
        }
        String relativePath = qualifiedPath.substring(prefix.length());
        return relativePath;
    }

    private String getHomeFolderPrefix() {
        String homeFolderPath = this._homeFolder.getQualifiedPath();
        if ("/".equals(homeFolderPath)) {
            return homeFolderPath;
        }
        return homeFolderPath + "/";
    }

    @Override
    public String getScheme() {
        return "repo";
    }

    @Override
    public RepositoryFileResource parsePath(String path) {
        String qualifiedPath = this.getHomeFolderPrefix() + path;
        return new RepositoryFileResource(this._repository, qualifiedPath);
    }
}

