/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.metamodel.util.Resource;
import org.datacleaner.api.Converter;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.SystemProperties;
import org.datacleaner.util.convert.ClasspathResourceTypeHandler;
import org.datacleaner.util.convert.FileResourceTypeHandler;
import org.datacleaner.util.convert.HdfsResourceTypeHandler;
import org.datacleaner.util.convert.UrlResourceTypeHandler;
import org.datacleaner.util.convert.VfsResourceTypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConverter
implements Converter<Resource> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceConverter.class);
    @Deprecated
    public static final String DEFAULT_DEFAULT_SCHEME = "file";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("\\b([a-zA-Z]+)://(.+)");
    private final DataCleanerConfiguration _configuration;
    private final Map<String, ResourceTypeHandler<?>> _parsers;
    private final String _defaultScheme;

    public static String getConfiguredDefaultScheme() {
        return SystemProperties.getString("datacleaner.resources.scheme.default", DEFAULT_DEFAULT_SCHEME);
    }

    private static List<ResourceTypeHandler<?>> createDefaultHandlers(DataCleanerConfiguration configuration) {
        ArrayList result = new ArrayList();
        result.add(new FileResourceTypeHandler(configuration.getHomeFolder()));
        result.add(new UrlResourceTypeHandler());
        result.add(new HdfsResourceTypeHandler("hdfs", configuration));
        result.add(new HdfsResourceTypeHandler("emrfs", configuration));
        result.add(new HdfsResourceTypeHandler("maprfs", configuration));
        result.add(new HdfsResourceTypeHandler("s3", configuration));
        result.add(new HdfsResourceTypeHandler("swift", configuration));
        result.add(new ClasspathResourceTypeHandler());
        result.add(new VfsResourceTypeHandler());
        return result;
    }

    public ResourceConverter withExtraHandlers(Collection<? extends ResourceTypeHandler<?>> extraHandlers) {
        ArrayList handlers = new ArrayList(this._parsers.values());
        handlers.addAll(extraHandlers);
        return new ResourceConverter(this._configuration, handlers);
    }

    public ResourceConverter(DataCleanerConfiguration configuration) {
        this(configuration, ResourceConverter.getConfiguredDefaultScheme());
    }

    public ResourceConverter(DataCleanerConfiguration configuration, String defaultScheme) {
        this(configuration, ResourceConverter.createDefaultHandlers(configuration), defaultScheme);
    }

    public ResourceConverter(DataCleanerConfiguration configuration, Collection<? extends ResourceTypeHandler<?>> handlers) {
        this(configuration, handlers, ResourceConverter.getConfiguredDefaultScheme());
    }

    public ResourceConverter(Collection<? extends ResourceTypeHandler<?>> handlers, String defaultScheme) {
        this(new DataCleanerConfigurationImpl(), handlers, defaultScheme);
    }

    public ResourceConverter(DataCleanerConfiguration configuration, Collection<? extends ResourceTypeHandler<?>> handlers, String defaultScheme) {
        this._defaultScheme = defaultScheme;
        this._parsers = new ConcurrentHashMap();
        this._configuration = configuration;
        for (ResourceTypeHandler<?> handler : handlers) {
            String scheme = handler.getScheme();
            this._parsers.put(scheme, handler);
        }
    }

    public ResourceConverter(ResourceTypeHandler<?> ... handlers) {
        this(new DataCleanerConfigurationImpl(), Arrays.asList(handlers), ResourceConverter.getConfiguredDefaultScheme());
    }

    public Resource fromString(Class<?> type, String serializedForm) {
        ResourceStructure structure = this.parseStructure(serializedForm);
        if (structure == null) {
            throw new IllegalStateException("Invalid resource format: " + serializedForm);
        }
        String scheme = structure.getScheme();
        ResourceTypeHandler<?> handler = this._parsers.get(scheme);
        if (handler == null) {
            throw new IllegalStateException("No handler found for scheme of resource: " + serializedForm);
        }
        Object resource = handler.parsePath(structure.getPath());
        return resource;
    }

    public String toString(Resource resource) {
        Class<?> resourceType = resource.getClass();
        Collection<ResourceTypeHandler<?>> values = this._parsers.values();
        for (ResourceTypeHandler<?> handler : values) {
            if (!handler.isParserFor(resourceType)) continue;
            String path = handler.createPath(resource);
            String scheme = handler.getScheme();
            return scheme + "://" + path;
        }
        throw new IllegalStateException("Could not find a resource handler for resource: " + resource);
    }

    public Collection<ResourceTypeHandler<?>> getResourceTypeHandlers() {
        return Collections.unmodifiableCollection(this._parsers.values());
    }

    public boolean isConvertable(Class<?> type) {
        return ReflectionUtils.is(type, Resource.class);
    }

    public ResourceStructure parseStructure(String str) {
        Matcher matcher = RESOURCE_PATTERN.matcher(str);
        if (!matcher.find()) {
            logger.info("Did not find any scheme definition in resource path: {}. Using default scheme: {}.", (Object)str, (Object)this._defaultScheme);
            return new ResourceStructure(this._defaultScheme, str);
        }
        String scheme = matcher.group(1);
        String path = matcher.group(2);
        return new ResourceStructure(scheme, path);
    }

    public static class ResourceStructure {
        private final String scheme;
        private final String path;

        public ResourceStructure(String scheme, String path) {
            this.scheme = scheme;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static interface ResourceTypeHandler<E extends Resource> {
        public boolean isParserFor(Class<? extends Resource> var1);

        public String getScheme();

        public E parsePath(String var1);

        public String createPath(Resource var1);
    }
}

