/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datacleaner.util.convert.ExpressionDate;

public class ShiftedToday
extends Date
implements ExpressionDate {
    private static final long serialVersionUID = 1L;
    private final String _input;

    public ShiftedToday(String input) {
        this._input = ShiftedToday.validateInput(input);
        int[] counts = this.parseCounts();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, counts[0]);
        calendar.add(2, counts[1]);
        calendar.add(1, counts[2]);
        this.setTime(calendar.getTime().getTime());
    }

    private static String validateInput(String input) {
        String regexp = "shifted_today[(](.+)[)]";
        Pattern pattern = Pattern.compile("shifted_today[(](.+)[)]");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }

    private int[] parseCounts() {
        String regexp = "^.*?([-+]?[0-9]+)[dD] *([-+]?[0-9]+)[mM] *([-+]?[0-9]+)[yY].*$";
        Pattern pattern = Pattern.compile("^.*?([-+]?[0-9]+)[dD] *([-+]?[0-9]+)[mM] *([-+]?[0-9]+)[yY].*$");
        Matcher matcher = pattern.matcher(this._input);
        if (!matcher.find()) {
            throw new RuntimeException(String.format("Specified value ('%s') does not match allowed format (1d 2m 3y). ", this._input));
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))};
    }

    public String getInput() {
        return this._input;
    }

    @Override
    public String getExpression() {
        return String.format("shifted_today(%s)", this._input);
    }
}

