/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.apache.commons.lang.SerializationUtils;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Converter;
import org.datacleaner.components.convert.ConvertToDateTransformer;
import org.datacleaner.components.convert.ConvertToNumberTransformer;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.descriptors.EnumerationValue;
import org.datacleaner.util.ChangeAwareObjectInputStream;
import org.datacleaner.util.FileResolver;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.ExpressionDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTypeConverter
implements Converter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(StandardTypeConverter.class);
    private static final String dateFormatString = "yyyy-MM-dd'T'HH:mm:ss S";
    @Inject
    Converter<Object> _parentConverter;
    @Inject
    DataCleanerConfiguration _configuration;

    public StandardTypeConverter() {
        this(null, null);
    }

    public StandardTypeConverter(DataCleanerConfiguration configuration, Converter<Object> parentConverter) {
        this._configuration = configuration;
        this._parentConverter = parentConverter;
    }

    public Object fromString(Class<?> type, String str) {
        if (ReflectionUtils.isString(type)) {
            return str;
        }
        if (ReflectionUtils.isBoolean(type)) {
            return Boolean.valueOf(str);
        }
        if (ReflectionUtils.isCharacter(type)) {
            return Character.valueOf(str.charAt(0));
        }
        if (ReflectionUtils.isInteger(type)) {
            return Integer.valueOf(str);
        }
        if (ReflectionUtils.isLong(type)) {
            return Long.valueOf(str);
        }
        if (ReflectionUtils.isByte(type)) {
            return Byte.valueOf(str);
        }
        if (ReflectionUtils.isShort(type)) {
            return Short.valueOf(str);
        }
        if (ReflectionUtils.isDouble(type)) {
            return Double.valueOf(str);
        }
        if (ReflectionUtils.isFloat(type)) {
            return Float.valueOf(str);
        }
        if (ReflectionUtils.is(type, Class.class)) {
            try {
                return Class.forName(str);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not found: " + str, e);
            }
        }
        if (ReflectionUtils.is(type, EnumerationValue.class)) {
            return new EnumerationValue(str);
        }
        if (type.isEnum()) {
            try {
                String name;
                ?[] enumConstants = type.getEnumConstants();
                Method nameMethod = Enum.class.getMethod("name", new Class[0]);
                for (Object e : enumConstants) {
                    name = (String)nameMethod.invoke(e, new Object[0]);
                    if (!name.equals(str)) continue;
                    return e;
                }
                for (Object e : enumConstants) {
                    String[] aliasValues;
                    name = (String)nameMethod.invoke(e, new Object[0]);
                    Field field = type.getField(name);
                    Alias alias = ReflectionUtils.getAnnotation(field, Alias.class);
                    if (alias == null) continue;
                    for (String aliasValue : aliasValues = alias.value()) {
                        if (!aliasValue.equals(str)) continue;
                        return e;
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected error occurred while examining enum", e);
            }
            throw new IllegalArgumentException("No such enum '" + str + "' in enum class: " + type.getName());
        }
        if (ReflectionUtils.isDate(type)) {
            return StandardTypeConverter.toDate(str);
        }
        if (ReflectionUtils.is(type, File.class)) {
            FileResolver fileResolver = new FileResolver(this._configuration);
            return fileResolver.toFile(str);
        }
        if (ReflectionUtils.is(type, Calendar.class)) {
            java.util.Date date = StandardTypeConverter.toDate(str);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return c;
        }
        if (ReflectionUtils.is(type, Pattern.class)) {
            try {
                return Pattern.compile(str);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid regular expression syntax in '" + str + "'.", e);
            }
        }
        if (ReflectionUtils.is(type, Date.class)) {
            java.util.Date date = StandardTypeConverter.toDate(str);
            return new Date(date.getTime());
        }
        if (ReflectionUtils.isNumber(type)) {
            return ConvertToNumberTransformer.transformValue(str);
        }
        if (ReflectionUtils.is(type, Serializable.class)) {
            Object object;
            logger.warn("fromString(...): No built-in handling of type: {}, using deserialization", (Object)type.getName());
            byte[] bytes = (byte[])this._parentConverter.fromString(byte[].class, str);
            ChangeAwareObjectInputStream objectInputStream = null;
            try {
                Object obj;
                objectInputStream = new ChangeAwareObjectInputStream(new ByteArrayInputStream(bytes));
                objectInputStream.addClassLoader(type.getClassLoader());
                object = obj = objectInputStream.readObject();
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException("Could not deserialize to " + type + ".", e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{objectInputStream});
                    throw throwable;
                }
            }
            FileHelper.safeClose((Object[])new Object[]{objectInputStream});
            return object;
        }
        throw new IllegalArgumentException("Could not convert to type: " + type.getName());
    }

    public String toString(Object o) {
        String result;
        if (o instanceof Calendar) {
            o = ((Calendar)o).getTime();
        }
        if (o instanceof Boolean || o instanceof Number || o instanceof String || o instanceof Character) {
            result = o.toString();
        } else {
            if (o instanceof File) {
                File file = (File)o;
                FileResolver fileResolver = new FileResolver(this._configuration);
                return fileResolver.toPath(file);
            }
            if (o instanceof java.util.Date) {
                result = o instanceof ExpressionDate ? ((ExpressionDate)o).getExpression() : new SimpleDateFormat(dateFormatString).format((java.util.Date)o);
            } else if (o instanceof Pattern) {
                result = o.toString();
            } else {
                if (o instanceof Enum) {
                    return ((Enum)o).name();
                }
                if (o instanceof Class) {
                    result = ((Class)o).getName();
                } else if (o instanceof EnumerationValue) {
                    result = ((EnumerationValue)o).getValue();
                } else if (o instanceof Serializable) {
                    logger.info("toString(...): No built-in handling of type: {}, using serialization.", (Object)o.getClass().getName());
                    byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)o));
                    result = this._parentConverter.toString((Object)bytes);
                } else {
                    logger.warn("toString(...): Could not convert type: {}", (Object)o.getClass().getName());
                    result = o.toString();
                }
            }
        }
        return result;
    }

    private static final java.util.Date toDate(String str) {
        try {
            return new SimpleDateFormat(dateFormatString).parse(str);
        }
        catch (ParseException e) {
            java.util.Date date = ConvertToDateTransformer.getInternalInstance().transformValue(str);
            if (date == null) {
                logger.error("Could not parse date: " + str, (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            return date;
        }
    }

    public boolean isConvertable(Class<?> type) {
        return ReflectionUtils.is(type, Serializable.class) || type.isPrimitive();
    }
}

