/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datacleaner.api.Converter;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.InjectionManagerFactory;
import org.datacleaner.configuration.InjectionPoint;
import org.datacleaner.configuration.SimpleInjectionPoint;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.util.convert.ConfigurationItemConverter;
import org.datacleaner.util.convert.DelegatingConverter;
import org.datacleaner.util.convert.ResourceConverter;
import org.datacleaner.util.convert.StandardTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringConverter.class);
    private static final StringConverter SIMPLE_INSTANCE = new StringConverter(new DataCleanerConfigurationImpl());
    private final InjectionManager _injectionManager;
    private final DataCleanerConfiguration _configuration;
    private final DelegatingConverter _baseConverter;

    public static StringConverter simpleInstance() {
        return SIMPLE_INSTANCE;
    }

    public StringConverter(DataCleanerConfiguration configuration, AnalysisJob job) {
        this(StringConverter.getInjectionManager(configuration, job));
    }

    public StringConverter(DataCleanerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("DataCleanerConfiguration cannot be null");
        }
        this._configuration = configuration;
        this._injectionManager = configuration.getEnvironment().getInjectionManagerFactory().getInjectionManager(configuration);
        this._baseConverter = this.createBaseConverter();
    }

    public StringConverter(InjectionManager injectionManager) {
        if (injectionManager == null) {
            throw new IllegalArgumentException("InjectionManager cannot be null");
        }
        InjectionPoint<DataCleanerConfiguration> injectionPoint = SimpleInjectionPoint.of(DataCleanerConfiguration.class);
        this._configuration = (DataCleanerConfiguration)injectionManager.getInstance(injectionPoint);
        this._injectionManager = injectionManager;
        this._baseConverter = this.createBaseConverter();
    }

    private DelegatingConverter createBaseConverter() {
        DelegatingConverter baseConverter = new DelegatingConverter();
        baseConverter.addConverter(new ConfigurationItemConverter());
        baseConverter.addConverter(this.getResourceConverter());
        baseConverter.addConverter(new StandardTypeConverter(this._configuration, baseConverter));
        baseConverter.initializeAll(this._injectionManager);
        return baseConverter;
    }

    private static InjectionManager getInjectionManager(DataCleanerConfiguration configuration, AnalysisJob job) {
        InjectionManagerFactory injectionManagerFactory = configuration.getEnvironment().getInjectionManagerFactory();
        if (job == null) {
            return injectionManagerFactory.getInjectionManager(configuration);
        }
        return injectionManagerFactory.getInjectionManager(configuration, job);
    }

    public final String serialize(Object o) {
        return this.serialize(o, new ArrayList(0));
    }

    public final String serialize(Object o, Class<? extends Converter<?>> converterClass) {
        Converter<?> converter = converterClass == null ? null : this.createConverter(converterClass);
        return this.serialize(o, converter);
    }

    public final String serialize(Object o, Converter<?> converter) {
        ArrayList col = new ArrayList();
        if (converter != null) {
            col.add(converter);
        }
        return this.serialize(o, col);
    }

    public final String serialize(Object o, Collection<Converter<?>> converters) {
        DelegatingConverter delegatingConverter = new DelegatingConverter();
        if (converters != null) {
            for (Converter<?> converter : converters) {
                delegatingConverter.addConverter(converter);
            }
        }
        delegatingConverter.addConverter(new ConfigurationItemConverter());
        delegatingConverter.addConverter(this.getResourceConverter());
        delegatingConverter.addConverter(new StandardTypeConverter(this._configuration, delegatingConverter));
        delegatingConverter.initializeAll(this._injectionManager);
        return delegatingConverter.toString(o);
    }

    private ResourceConverter getResourceConverter() {
        if (this._injectionManager == null) {
            return new ResourceConverter(this._configuration);
        }
        ResourceConverter converter = (ResourceConverter)this._injectionManager.getInstance(SimpleInjectionPoint.of(ResourceConverter.class));
        if (converter == null) {
            return new ResourceConverter(this._configuration);
        }
        return converter;
    }

    private Converter<?> createConverter(Class<? extends Converter<?>> converterClass) {
        try {
            Converter<?> converter = converterClass.newInstance();
            return converter;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Error occurred while using instantiating: " + converterClass, e);
        }
    }

    public final <E> E deserialize(String str, Class<E> type) {
        return this.deserialize(str, type, new ArrayList(0));
    }

    public final <E> E deserialize(String str, Class<E> type, Class<? extends Converter<?>> converterClass) {
        if (converterClass == null) {
            return this.deserialize(str, type);
        }
        return this.deserialize(str, type, this.createConverter(converterClass));
    }

    public final <E> E deserialize(String str, Class<E> type, Converter<?> converter) {
        ArrayList col = new ArrayList();
        if (converter != null) {
            col.add(converter);
        }
        return this.deserialize(str, type, col);
    }

    public final <E> E deserialize(String str, Class<E> type, Collection<Converter<?>> converters) {
        logger.debug("deserialize(\"{}\", {})", (Object)str, type);
        if (converters == null || converters.isEmpty()) {
            Object result = this._baseConverter.fromString(type, str);
            return (E)result;
        }
        DelegatingConverter delegatingConverter = new DelegatingConverter();
        if (converters != null) {
            for (Converter<?> converter : converters) {
                delegatingConverter.addConverter(converter);
                delegatingConverter.initialize(converter, this._injectionManager);
            }
        }
        List<Converter<?>> baseconverters = this._baseConverter.getConverters();
        for (Converter<?> converter : baseconverters) {
            delegatingConverter.addConverter(converter);
        }
        Object object = delegatingConverter.fromString(type, str);
        return (E)object;
    }
}

