/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.http;

import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.util.http.MonitorHttpClient;

public class HttpBasicMonitorHttpClient
implements MonitorHttpClient {
    private final CloseableHttpClient _httpClient;
    private final HttpClientContext _context;

    public HttpBasicMonitorHttpClient(CloseableHttpClient httpClient, String hostname, int port, String username, String password) {
        this(httpClient, hostname, port, username, password, false);
    }

    public HttpBasicMonitorHttpClient(CloseableHttpClient httpClient, String hostname, int port, String username, String password, boolean preemptiveAuth) {
        this._httpClient = httpClient;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        credentialsProvider.setCredentials(new AuthScope(hostname, port), (Credentials)credentials);
        this._context = HttpClientContext.create();
        this._context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (preemptiveAuth) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicScheme = new BasicScheme();
            authCache.put(new HttpHost(hostname, port, "http"), (AuthScheme)basicScheme);
            authCache.put(new HttpHost(hostname, port, "https"), (AuthScheme)basicScheme);
            this._context.setAuthCache((AuthCache)authCache);
        }
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws Exception {
        this.addSecurityHeaders(request);
        return this._httpClient.execute(request, (HttpContext)this._context);
    }

    @Override
    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._httpClient});
    }

    protected void addSecurityHeaders(HttpUriRequest request) throws Exception {
    }
}

