/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.datacleaner.user.UserPreferences;
import org.datacleaner.util.http.InvalidHttpResponseException;
import org.datacleaner.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class HttpXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpXmlUtils.class);
    private final UserPreferences _userPreferences;
    private final HttpClient _httpClient;

    @Inject
    public HttpXmlUtils(UserPreferences userPreferences) {
        this._userPreferences = userPreferences;
        this._httpClient = null;
    }

    public HttpXmlUtils(HttpClient httpClient) {
        this._userPreferences = null;
        this._httpClient = httpClient;
    }

    public String getUrlContent(String url, Map<String, String> params) throws IOException {
        if (params == null) {
            params = Collections.emptyMap();
        }
        logger.info("getUrlContent({},{})", (Object)url, params);
        HttpPost method = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String response = (String)this.getHttpClient().execute((HttpUriRequest)method, (ResponseHandler)responseHandler);
        return response;
    }

    private HttpClient getHttpClient() {
        if (this._httpClient == null) {
            return this._userPreferences.createHttpClient();
        }
        return this._httpClient;
    }

    public static Element getRootNode(HttpClient httpClient, String url) throws InvalidHttpResponseException {
        logger.info("getRootNode({})", (Object)url);
        try {
            HttpGet method = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.error("Response status code was: {} (url={})", (Object)statusCode, (Object)url);
                throw new InvalidHttpResponseException(url, response);
            }
            InputStream inputStream = response.getEntity().getContent();
            Document document = XmlUtils.createDocumentBuilder().parse(inputStream);
            return (Element)document.getFirstChild();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Could not get root XML node of url=" + url, e);
        }
    }

    public static List<Node> getChildNodesByName(Node parentNode, String childNodeName) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (childNodeName != null) {
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNodeName.equals(childNode.getNodeName())) continue;
                result.add(childNode);
            }
        }
        return result;
    }

    public static String getChildNodeText(Node node, String childNodeName) {
        List<Node> childNodes = HttpXmlUtils.getChildNodesByName(node, childNodeName);
        if (childNodes.isEmpty()) {
            return null;
        }
        if (childNodes.size() > 1) {
            throw new IllegalArgumentException("The node " + node + " contains several childNodes named " + childNodeName);
        }
        return HttpXmlUtils.getText(childNodes.get(0));
    }

    public static String getText(Node node) {
        Element element = (Element)node;
        return element.getTextContent();
    }
}

