/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.ws;

import java.util.concurrent.Callable;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.datacleaner.util.ws.ConnectionPoolObjectFactory;
import org.datacleaner.util.ws.RetryServiceSession;
import org.datacleaner.util.ws.ServiceResult;

public class PooledServiceSession<R>
extends RetryServiceSession<R> {
    private final GenericObjectPool<Integer> _connectionPool;

    public PooledServiceSession(GenericObjectPool<Integer> pool) {
        this(pool, 0, null);
    }

    public PooledServiceSession(GenericObjectPool<Integer> pool, int maxRetries, int[] sleepTimeBetweenRetries) {
        super(maxRetries, sleepTimeBetweenRetries);
        this._connectionPool = pool;
    }

    public PooledServiceSession(int maxConnections) {
        this(maxConnections, 0, null);
    }

    public PooledServiceSession(int maxConnections, int maxRetries, int[] sleepTimeBetweenRetries) {
        super(maxRetries, sleepTimeBetweenRetries);
        this._connectionPool = PooledServiceSession.createConnectionPool(maxConnections);
    }

    public static GenericObjectPool<Integer> createConnectionPool(int maxConnections) {
        GenericObjectPool connectionPool = new GenericObjectPool((PoolableObjectFactory)new ConnectionPoolObjectFactory());
        connectionPool.setMaxActive(maxConnections);
        connectionPool.setWhenExhaustedAction((byte)1);
        return connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResult<R> invokeService(Callable<R> callable) {
        Integer poolObject = this.borrowObject();
        try {
            ServiceResult<R> serviceResult = super.invokeService(callable);
            return serviceResult;
        }
        finally {
            this.returnObject(poolObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E invokeAdhocService(Callable<E> callable) throws RuntimeException, IllegalStateException {
        Integer poolObject = this.borrowObject();
        try {
            E e = super.invokeAdhocService(callable);
            return e;
        }
        finally {
            this.returnObject(poolObject);
        }
    }

    private Integer borrowObject() {
        try {
            return (Integer)this._connectionPool.borrowObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not borrow pool object", e);
        }
    }

    private void returnObject(Integer poolObject) {
        try {
            this._connectionPool.returnObject((Object)poolObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not return pool object", e);
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            this._connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

