/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.ws;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.util.ws.ServiceResult;
import org.datacleaner.util.ws.ServiceSession;
import org.datacleaner.util.ws.SimpleServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryServiceSession<R>
extends SimpleServiceSession<R>
implements ServiceSession<R> {
    public static final int DEFAULT_RETRY_SLEEP_TIME = 1000;
    private static final Logger logger = LoggerFactory.getLogger(SimpleServiceSession.class);
    private final int _maxRetries;
    private final AtomicInteger _successCount;
    private final AtomicInteger _retryCount;
    private final AtomicInteger _failureCount;
    private final int[] _sleepTimeBetweenRetries;

    public RetryServiceSession(int maxRetries) {
        this(maxRetries, null);
    }

    public RetryServiceSession(int maxRetries, int[] sleepTimeBetweenRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("Max retries cannot be a negative number");
        }
        this._maxRetries = maxRetries;
        this._sleepTimeBetweenRetries = sleepTimeBetweenRetries;
        this._successCount = new AtomicInteger();
        this._retryCount = new AtomicInteger();
        this._failureCount = new AtomicInteger();
    }

    @Override
    public ServiceResult<R> invokeService(Callable<R> callable) {
        int attemptNo = 1;
        while (true) {
            ServiceResult<R> result;
            if ((result = super.invokeService(callable)).isSuccesfull()) {
                this._successCount.incrementAndGet();
                return result;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Attempt no. " + attemptNo + " to invoke service failed", result.getError());
            }
            if (attemptNo > this._maxRetries) {
                this._failureCount.incrementAndGet();
                return result;
            }
            long sleepTime = this.getSleepTime(attemptNo);
            ++attemptNo;
            this._retryCount.incrementAndGet();
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private long getSleepTime(int attemptNo) {
        int index = attemptNo - 1;
        if (this._sleepTimeBetweenRetries != null && this._sleepTimeBetweenRetries.length > index) {
            return this._sleepTimeBetweenRetries[index];
        }
        return 1000L;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public int getRetryCount() {
        return this._retryCount.get();
    }

    public int getFailureCount() {
        return this._failureCount.get();
    }

    public int getSuccessCount() {
        return this._successCount.get();
    }
}

