/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlUtils {
    private XmlUtils() {
    }

    public static void writeDocument(Node docOrNode, OutputStream out) {
        XmlUtils.writeDocument(docOrNode, out, true);
    }

    public static void writeDocument(Node docOrNode, OutputStream out, boolean includeXmlDeclaration) {
        Transformer transformer = XmlUtils.createTransformer(includeXmlDeclaration);
        try {
            DOMSource source = new DOMSource(docOrNode);
            StreamResult outputTarget = new StreamResult(out);
            transformer.transform(source, outputTarget);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Transformer createTransformer() {
        return XmlUtils.createTransformer(true);
    }

    public static Transformer createTransformer(boolean includeXmlDeclaration) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            if (!includeXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Document parseDocument(InputStream in) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(in);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Document createDocument() {
        return XmlUtils.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String writeDocumentToString(Node node, boolean includeXmlDeclaration) {
        Transformer transformer = XmlUtils.createTransformer(includeXmlDeclaration);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(node);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
        String xmlString = sw.toString();
        return xmlString;
    }
}

