/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.schema.naming.CustomColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.InMemoryResource;
import org.apache.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConfigurationDetection {
    private static final Logger logger = LoggerFactory.getLogger(CsvConfigurationDetection.class);
    private static final int SAMPLE_BUFFER_SIZE = 131072;
    private final Resource _resource;
    private List<String> _columnNames;

    public CsvConfigurationDetection(File file) {
        this._resource = new FileResource(file);
    }

    public CsvConfigurationDetection(Resource resource) {
        this._resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSampleBuffer() {
        byte[] byArray;
        byte[] bytes = new byte[131072];
        InputStream inputStream = this._resource.read();
        try {
            int bufferSize = inputStream.read(bytes, 0, 131072);
            if (bufferSize != -1 && bufferSize != 131072) {
                bytes = Arrays.copyOf(bytes, bufferSize);
            }
            byArray = bytes;
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                logger.error("IOException occurred while reading sample buffer", (Throwable)e);
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return byArray2;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return byArray;
    }

    public String suggestEncoding() {
        return this.suggestEncoding(this.getSampleBuffer());
    }

    protected String suggestEncoding(byte[] bytes) {
        CharsetDetector cd = new CharsetDetector();
        cd.setText(bytes);
        CharsetMatch charsetMatch = cd.detect();
        String charSet = charsetMatch.getName();
        int confidence = charsetMatch.getConfidence();
        logger.info("CharsetMatch: {} ({}% confidence)", (Object)charSet, (Object)confidence);
        return charSet;
    }

    public CsvConfiguration suggestCsvConfiguration(String encoding, List<String> columnNames) throws IllegalStateException {
        byte[] sample = this.getSampleBuffer();
        return this.suggestCsvConfiguration(sample, encoding, columnNames);
    }

    public CsvConfiguration suggestCsvConfiguration() throws IllegalStateException {
        return this.suggestCsvConfiguration(null);
    }

    public CsvConfiguration suggestCsvConfiguration(List<String> columnNames) throws IllegalStateException {
        byte[] sample = this.getSampleBuffer();
        String encoding = this.suggestEncoding(sample);
        return this.suggestCsvConfiguration(sample, encoding, columnNames);
    }

    private CsvConfiguration suggestCsvConfiguration(byte[] sample, String encoding, List<String> columnNames) throws IllegalStateException {
        CustomColumnNamingStrategy columnNamingStategy;
        char[] sampleChars = this.readSampleBuffer(sample, encoding);
        if (this.indexOf('\n', sampleChars) == -1 && this.indexOf('\r', sampleChars) == -1) {
            throw new IllegalStateException("No newline in first " + sampleChars.length + " chars");
        }
        int newlines = 0;
        int tabs = 0;
        int commas = 0;
        int semicolons = 0;
        int pipes = 0;
        int singleQuotes = 0;
        int doubleQuotes = 0;
        int backslashes = 0;
        for (int i = 0; i < sampleChars.length; ++i) {
            char c = sampleChars[i];
            if (c == '\n') {
                ++newlines;
                continue;
            }
            if (c == '\t') {
                ++tabs;
                continue;
            }
            if (c == ',') {
                ++commas;
                continue;
            }
            if (c == ';') {
                ++semicolons;
                continue;
            }
            if (c == '\'') {
                ++singleQuotes;
                continue;
            }
            if (c == '|') {
                ++pipes;
                continue;
            }
            if (c == '\"') {
                ++doubleQuotes;
                continue;
            }
            if (c != '\\') continue;
            ++backslashes;
        }
        int detectedSeparator = Math.max(tabs, Math.max(commas, Math.max(semicolons, pipes)));
        char separatorChar = detectedSeparator == 0 || detectedSeparator < newlines ? (char)',' : (detectedSeparator == commas ? (char)',' : (detectedSeparator == semicolons ? (char)';' : (detectedSeparator == tabs ? (char)'\t' : (detectedSeparator == pipes ? (char)'|' : ','))));
        char escapeChar = backslashes > 0 ? (char)'\\' : '\uffff';
        int detectedQuote = Math.max(singleQuotes, doubleQuotes);
        char quoteChar = detectedQuote == 0 || detectedQuote < newlines ? (char)'\"' : (detectedQuote == singleQuotes ? (char)'\'' : (detectedQuote == doubleQuotes ? (char)'\"' : '\"'));
        if (columnNames != null && columnNames.size() > 0) {
            columnNamingStategy = new CustomColumnNamingStrategy(columnNames);
            this._columnNames = columnNames;
        } else {
            columnNamingStategy = null;
        }
        boolean multiline = false;
        CsvConfiguration multiLineConfiguration = new CsvConfiguration(1, (ColumnNamingStrategy)columnNamingStategy, encoding, separatorChar, quoteChar, escapeChar, false, true);
        try {
            CsvDataContext testDataContext = new CsvDataContext((Resource)new InMemoryResource("foo.txt", sample, System.currentTimeMillis()), multiLineConfiguration);
            Table table = testDataContext.getDefaultSchema().getTable(0);
            if (this._columnNames == null) {
                this._columnNames = testDataContext.getDefaultSchema().getTable(0).getColumnNames();
            }
            try (DataSet dataSet = testDataContext.query().from(table).select(table.getColumns()).execute();){
                block12: while (dataSet.next()) {
                    Object[] values;
                    Row row = dataSet.getRow();
                    for (Object value : values = row.getValues()) {
                        if (value == null || !(value instanceof String) || ((String)value).indexOf(10) == -1) continue;
                        multiline = true;
                        continue block12;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to detect multiline property of CsvConfiguration, defaulting to 'true'", (Throwable)e);
            return multiLineConfiguration;
        }
        return new CsvConfiguration(1, (ColumnNamingStrategy)columnNamingStategy, encoding, separatorChar, quoteChar, escapeChar, false, multiline);
    }

    private int indexOf(char c, char[] sampleChars) {
        for (int i = 0; i < sampleChars.length; ++i) {
            if (c != sampleChars[i]) continue;
            return i;
        }
        return -1;
    }

    protected char[] readSampleBuffer(byte[] bytes, String charSet) throws IllegalStateException {
        char[] buffer = new char[bytes.length];
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charSet);
            int bufferSize = reader.read(buffer);
            if (bufferSize != -1) {
                buffer = Arrays.copyOf(buffer, bufferSize);
            }
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Error reading from file: " + e.getMessage(), (Throwable)e);
            }
            throw new IllegalStateException("Error reading from file: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    logger.debug("Could not close reader", (Throwable)ioe);
                }
            }
        }
        return buffer;
    }

    public List<String> getColumnNames() {
        return this._columnNames;
    }
}

