/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadObjectBuilder<E extends Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(ReadObjectBuilder.class);
    private final E _serializable;
    private final Class<? super E> _clazz;

    private ReadObjectBuilder(E serializable, Class<? super E> clazz) {
        this._serializable = serializable;
        this._clazz = clazz;
    }

    public static <E extends Serializable> ReadObjectBuilder<E> create(E serializable, Class<? super E> clazz) {
        logger.debug("Creating ReadObjectBuilder for new object of {}", clazz);
        return new ReadObjectBuilder<E>(serializable, clazz);
    }

    public void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readObject(stream, null);
    }

    public void readObject(ObjectInputStream stream, Adaptor adaptor) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream.GetField getField = stream.readFields();
            Field[] fields = this._clazz.getDeclaredFields();
            this.deserializeFields(fields, getField);
            fields = ReflectionUtils.getAllFields(this._clazz, Moved.class);
            this.deserializeFields(fields, getField);
            if (adaptor != null) {
                adaptor.deserialize(getField, (Serializable)this._serializable);
            }
        }
        catch (Exception e) {
            logger.error("Could not deserialize object!", (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void deserializeFields(Field[] fields, ObjectInputStream.GetField getField) throws IOException {
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
            this.deserializeField(field, getField);
        }
    }

    private void deserializeField(Field field, ObjectInputStream.GetField getField) throws IOException {
        String fieldName = field.getName();
        try {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive()) {
                if (fieldType == Boolean.TYPE) {
                    boolean value = getField.get(fieldName, false);
                    field.setBoolean(this._serializable, value);
                } else if (fieldType == Byte.TYPE) {
                    byte value = getField.get(fieldName, (byte)0);
                    field.setByte(this._serializable, value);
                } else if (fieldType == Short.TYPE) {
                    short value = getField.get(fieldName, (short)0);
                    field.setShort(this._serializable, value);
                } else if (fieldType == Integer.TYPE) {
                    int value = getField.get(fieldName, 0);
                    field.setInt(this._serializable, value);
                } else if (fieldType == Long.TYPE) {
                    long value = getField.get(fieldName, 0L);
                    field.setLong(this._serializable, value);
                } else if (fieldType == Float.TYPE) {
                    float value = getField.get(fieldName, 0.0f);
                    field.setFloat(this._serializable, value);
                } else if (fieldType == Double.TYPE) {
                    double value = getField.get(fieldName, 0.0);
                    field.setDouble(this._serializable, value);
                } else if (fieldType == Character.TYPE) {
                    char value = getField.get(fieldName, '\u0000');
                    field.setChar(this._serializable, value);
                }
            } else {
                Object value = getField.get(fieldName, null);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}.{} was  {}", new Object[]{this._clazz, field, value});
                }
                if (value != null) {
                    field.set(this._serializable, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            logger.warn("Not allowed to access field: {}", (Object)fieldName);
        }
        catch (IllegalArgumentException e) {
            logger.debug("No such field found in GetFields: {}", (Object)fieldName);
        }
    }

    public static interface Adaptor {
        public void deserialize(ObjectInputStream.GetField var1, Serializable var2) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Documented
    @Inherited
    public static @interface Moved {
    }
}

