/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.Environment;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BerkeleyDbMap<K, V>
implements Map<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(BerkeleyDbMap.class);
    private final Map<K, V> _wrappedMap;
    private final Database _database;
    private final Environment _environment;

    public BerkeleyDbMap(Environment environment, Database database, StoredMap map) {
        this._environment = environment;
        this._database = database;
        this._wrappedMap = map;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        String name = this._database.getDatabaseName();
        this._database.close();
        this._environment.removeDatabase(null, name);
    }

    @Override
    public int size() {
        return this._wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._wrappedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        try {
            return this._wrappedMap.get(key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.warn("get('{}') threw exception: {}", key, (Object)e.getMessage());
            logger.warn("Swallowing exception, returning null", (Throwable)e);
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        return this._wrappedMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this._wrappedMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this._wrappedMap.putAll(m);
    }

    @Override
    public void clear() {
        this._wrappedMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._wrappedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return this._wrappedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this._wrappedMap.hashCode();
    }
}

