/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import org.datacleaner.storage.BerkeleyDbMap;

final class BerkeleyDbList<E>
extends AbstractList<E>
implements List<E> {
    private final BerkeleyDbMap<Integer, E> _wrappedMap;

    public Map<Integer, E> getWrappedMap() {
        return this._wrappedMap;
    }

    public BerkeleyDbList(BerkeleyDbMap<Integer, E> map) {
        this._wrappedMap = map;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._wrappedMap.finalize();
    }

    @Override
    public E get(int index) {
        if (!this._wrappedMap.containsKey(index)) {
            throw new IndexOutOfBoundsException();
        }
        E element = this._wrappedMap.get(index);
        return element;
    }

    @Override
    public int size() {
        return this._wrappedMap.size();
    }

    @Override
    public boolean add(E element) {
        this._wrappedMap.put(this._wrappedMap.size(), element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (!this._wrappedMap.containsKey(index)) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = this._wrappedMap.size(); i > index; --i) {
            this._wrappedMap.put(i, this._wrappedMap.get(i - 1));
        }
        this._wrappedMap.put(index, element);
    }

    @Override
    public E set(int index, E element) {
        if (!this._wrappedMap.containsKey(index)) {
            throw new IndexOutOfBoundsException();
        }
        return this._wrappedMap.put(index, element);
    }

    @Override
    public E remove(int index) {
        if (!this._wrappedMap.containsKey(index)) {
            throw new IndexOutOfBoundsException();
        }
        E element = this._wrappedMap.get(index);
        for (int i = index; i < this._wrappedMap.size() - 1; ++i) {
            this._wrappedMap.put(i, this._wrappedMap.get(i + 1));
        }
        this._wrappedMap.remove(this._wrappedMap.size() - 1);
        return element;
    }
}

