/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import com.sleepycat.bind.ByteArrayBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.BooleanBinding;
import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.CharacterBinding;
import com.sleepycat.bind.tuple.DoubleBinding;
import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.ShortBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import org.datacleaner.descriptors.ProvidedPropertyDescriptor;
import org.datacleaner.storage.BerkeleyDbList;
import org.datacleaner.storage.BerkeleyDbMap;
import org.datacleaner.storage.BerkeleyDbSet;
import org.datacleaner.storage.InMemoryRowAnnotationFactory2;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.StorageProvider;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BerkeleyDbStorageProvider
implements StorageProvider {
    private static final String DIRECTORY_PREFIX = "analyzerBeans_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File _parentDirectory;
    private File _targetDir;
    private Environment _environment;
    private boolean _deleteOnExit = false;

    public BerkeleyDbStorageProvider(File parentDirectory) {
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IllegalArgumentException("Could not create directory: " + parentDirectory);
        }
        this._parentDirectory = parentDirectory;
    }

    public File getParentDirectory() {
        return this._parentDirectory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._environment != null) {
            this._environment.close();
            this.cleanDirectory();
        }
    }

    public void cleanDirectory() {
        File[] directories;
        for (File directory : directories = this._parentDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(BerkeleyDbStorageProvider.DIRECTORY_PREFIX);
            }
        })) {
            this.delete(directory);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                this.delete(child);
            }
        }
        if (!file.delete()) {
            if (!file.isDirectory()) {
                this.logger.warn("Unable to clean/delete file: {}", (Object)file);
            } else {
                this.logger.debug("Unable to clean/delete directory: {}", (Object)file);
            }
        }
    }

    public Object createProvidedCollection(ProvidedPropertyDescriptor providedDescriptor) {
        Class typeArgument;
        Class clazz1 = typeArgument = providedDescriptor.getTypeArgument(0);
        if (providedDescriptor.isList()) {
            return this.createList(clazz1);
        }
        if (providedDescriptor.isSet()) {
            return this.createSet(clazz1);
        }
        if (providedDescriptor.isMap()) {
            Class clazz2 = providedDescriptor.getTypeArgument(1);
            return this.createMap(clazz1, clazz2);
        }
        throw new IllegalStateException();
    }

    protected Environment getEnvironment() throws DatabaseException {
        if (this._environment == null) {
            EnvironmentConfig config = new EnvironmentConfig();
            config.setAllowCreate(true);
            File targetDir = this.getTargetDir();
            this._environment = new Environment(targetDir, config);
        }
        return this._environment;
    }

    private File getTargetDir() {
        if (this._targetDir == null) {
            while (this._targetDir == null) {
                try {
                    File candidateDir = new File(this._parentDirectory, DIRECTORY_PREFIX + UUID.randomUUID().toString());
                    if (candidateDir.exists() || !candidateDir.mkdir()) continue;
                    this._targetDir = candidateDir;
                    this._deleteOnExit = true;
                }
                catch (Exception e) {
                    this.logger.error("Exception thrown while trying to create targetDir inside tempDir", (Throwable)e);
                    this._targetDir = this._parentDirectory;
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using target directory for persistent collections (deleteOnExit=" + this._deleteOnExit + "): " + this._targetDir.getAbsolutePath());
            }
            this.initDeleteOnExit(this._targetDir);
        }
        return this._targetDir;
    }

    private void initDeleteOnExit(File dir) {
        File[] files = dir.listFiles();
        dir.deleteOnExit();
        for (File file : files) {
            if (file.isDirectory()) {
                this.initDeleteOnExit(file);
                continue;
            }
            if (file.isFile()) {
                file.deleteOnExit();
                continue;
            }
            this.logger.warn("Unable to set the deleteOnExit flag on file: " + file);
        }
    }

    private Database createDatabase() throws DatabaseException {
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        String databaseName = UUID.randomUUID().toString();
        Database database = this.getEnvironment().openDatabase(null, databaseName, databaseConfig);
        return database;
    }

    public <E> BerkeleyDbList<E> createList(Class<E> valueType) throws IllegalStateException {
        Map map = this.createMap(Integer.class, valueType);
        return new BerkeleyDbList(map);
    }

    public <E> BerkeleyDbSet<E> createSet(Class<E> valueType) throws IllegalStateException {
        try {
            Database database = this.createDatabase();
            StoredKeySet set = new StoredKeySet(database, this.createBinding(valueType), true);
            return new BerkeleyDbSet(this.getEnvironment(), database, set);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    public <K, V> BerkeleyDbMap<K, V> createMap(Class<K> keyType, Class<V> valueType) throws IllegalStateException {
        try {
            EntryBinding keyBinding = this.createBinding(keyType);
            EntryBinding valueBinding = this.createBinding(valueType);
            Database database = this.createDatabase();
            StoredMap map = new StoredMap(database, keyBinding, valueBinding, true);
            return new BerkeleyDbMap(this.getEnvironment(), database, map);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    private EntryBinding createBinding(Type type) throws UnsupportedOperationException {
        if (ReflectionUtils.isString((Type)type)) {
            return new StringBinding();
        }
        if (ReflectionUtils.isInteger((Type)type)) {
            return new IntegerBinding();
        }
        if (ReflectionUtils.isLong((Type)type)) {
            return new LongBinding();
        }
        if (ReflectionUtils.isBoolean((Type)type)) {
            return new BooleanBinding();
        }
        if (ReflectionUtils.isShort((Type)type)) {
            return new ShortBinding();
        }
        if (ReflectionUtils.isByte((Type)type)) {
            return new ByteBinding();
        }
        if (ReflectionUtils.isDouble((Type)type)) {
            return new DoubleBinding();
        }
        if (ReflectionUtils.isFloat((Type)type)) {
            return new FloatBinding();
        }
        if (ReflectionUtils.isCharacter((Type)type)) {
            return new CharacterBinding();
        }
        if (ReflectionUtils.isByteArray((Type)type)) {
            return new ByteArrayBinding();
        }
        throw new UnsupportedOperationException("Cannot provide collection of type " + type);
    }

    public RowAnnotationFactory createRowAnnotationFactory() {
        return new InMemoryRowAnnotationFactory2();
    }
}

