/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.je.Database;
import com.sleepycat.je.Environment;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

final class BerkeleyDbSet<E>
implements Set<E> {
    private final Set<E> _wrappedSet;
    private final Environment _environment;
    private final Database _database;

    public BerkeleyDbSet(Environment environment, Database database, StoredKeySet set) {
        this._environment = environment;
        this._database = database;
        this._wrappedSet = set;
    }

    public Set<E> getWrappedSet() {
        return this._wrappedSet;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        String name = this._database.getDatabaseName();
        this._database.close();
        this._environment.removeDatabase(null, name);
    }

    @Override
    public int size() {
        return this._wrappedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this._wrappedSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._wrappedSet.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this._wrappedSet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this._wrappedSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._wrappedSet.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this._wrappedSet.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this._wrappedSet.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._wrappedSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this._wrappedSet.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._wrappedSet.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._wrappedSet.removeAll(c);
    }

    @Override
    public void clear() {
        this._wrappedSet.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this._wrappedSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this._wrappedSet.hashCode();
    }
}

