/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.cluster.AnalysisResultReductionException;
import org.datacleaner.cluster.DistributedAnalysisResultReducer;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobFailedException;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.JobStatus;
import org.datacleaner.result.AbstractAnalysisResult;

public final class DistributedAnalysisResultFuture
extends AbstractAnalysisResult
implements AnalysisResultFuture {
    private final DistributedAnalysisResultReducer _reducer;
    private final List<AnalysisResultFuture> _results;
    private final Map<ComponentJob, AnalyzerResult> _resultMap;
    private final List<AnalysisResultReductionException> _reductionErrors;
    private volatile Date _creationDate;
    private volatile boolean _cancelled;

    public DistributedAnalysisResultFuture(List<AnalysisResultFuture> results, DistributedAnalysisResultReducer reducer) {
        this._results = results;
        this._reducer = reducer;
        this._resultMap = new HashMap<ComponentJob, AnalyzerResult>();
        this._reductionErrors = new ArrayList<AnalysisResultReductionException>();
        this._cancelled = false;
    }

    public void cancel() {
        if (this.isDone()) {
            return;
        }
        if (!this._cancelled) {
            for (AnalysisResultFuture result : this._results) {
                result.cancel();
            }
            this._cancelled = true;
        }
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public Date getCreationDate() {
        if (!this.isDone()) {
            return null;
        }
        return this._creationDate;
    }

    public boolean isDone() {
        for (AnalysisResultFuture result : this._results) {
            if (result.isDone()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() {
        for (AnalysisResultFuture result : this._results) {
            result.await();
        }
        if (this._resultMap.isEmpty()) {
            DistributedAnalysisResultFuture distributedAnalysisResultFuture = this;
            synchronized (distributedAnalysisResultFuture) {
                if (this._resultMap.isEmpty() && this._reductionErrors.isEmpty()) {
                    this._reducer.reduce(this._results, this._resultMap, this._reductionErrors);
                }
            }
        }
    }

    public void await(long timeout, TimeUnit timeUnit) {
        long offsetMillis = System.currentTimeMillis();
        long millisToWait = timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
        for (AnalysisResultFuture result : this._results) {
            if (this.isDone()) continue;
            result.await(timeout, TimeUnit.MILLISECONDS);
            long currentMillis = System.currentTimeMillis();
            long duration = currentMillis - offsetMillis;
            if (duration < millisToWait) continue;
            return;
        }
    }

    public boolean isErrornous() {
        return !this.isSuccessful();
    }

    public boolean isSuccessful() {
        this.await();
        for (AnalysisResultFuture result : this._results) {
            if (!result.isErrornous()) continue;
            return false;
        }
        return this._reductionErrors.isEmpty();
    }

    public JobStatus getStatus() {
        if (this.isCancelled()) {
            return JobStatus.ERRORNOUS;
        }
        for (AnalysisResultFuture result : this._results) {
            JobStatus slaveStatus = result.getStatus();
            if (slaveStatus != JobStatus.NOT_FINISHED) continue;
            return JobStatus.NOT_FINISHED;
        }
        if (this.isSuccessful()) {
            return JobStatus.SUCCESSFUL;
        }
        return JobStatus.ERRORNOUS;
    }

    public List<AnalyzerResult> getResults() throws AnalysisJobFailedException {
        this.await();
        if (this.isErrornous()) {
            throw new AnalysisJobFailedException(this.getErrors());
        }
        Collection<AnalyzerResult> values = this._resultMap.values();
        return new ArrayList<AnalyzerResult>(values);
    }

    public Map<ComponentJob, AnalyzerResult> getResultMap() throws AnalysisJobFailedException {
        this.await();
        if (this.isErrornous()) {
            throw new AnalysisJobFailedException(this.getErrors());
        }
        return Collections.unmodifiableMap(this._resultMap);
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (AnalysisResultFuture result : this._results) {
            List slaveErrors = result.getErrors();
            if (slaveErrors == null) continue;
            errors.addAll(slaveErrors);
        }
        errors.addAll(this._reductionErrors);
        return errors;
    }
}

