/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster;

import org.datacleaner.cluster.JobDivisionManager;
import org.datacleaner.job.AnalysisJob;

public class FixedChunkSizeJobDivisionManager
implements JobDivisionManager {
    private final int _chunkSize;

    public FixedChunkSizeJobDivisionManager(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be a positive integer");
        }
        this._chunkSize = chunkSize;
    }

    @Override
    public int calculateDivisionCount(AnalysisJob masterJob, int expectedRows) {
        int chunkCount = (int)Math.ceil(1.0 * (double)expectedRows / (double)this._chunkSize);
        return chunkCount;
    }
}

