/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.LazyRef;
import org.datacleaner.cluster.ClusterManager;
import org.datacleaner.cluster.DistributedJobContext;
import org.datacleaner.cluster.FixedDivisionsCountJobDivisionManager;
import org.datacleaner.cluster.JobDivisionManager;
import org.datacleaner.cluster.LazyRefAnalysisResultFuture;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.JaxbJobWriter;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.result.AnalysisResult;
import org.datacleaner.util.ChangeAwareObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClusterManager
implements ClusterManager {
    private static final Logger logger = LoggerFactory.getLogger(HttpClusterManager.class);
    public static final String HTTP_PARAM_SLAVE_JOB_ID = "slave-job-id";
    public static final String HTTP_PARAM_ACTION = "action";
    public static final String HTTP_PARAM_JOB_DEF = "job-def";
    public static final String ACTION_RUN = "run";
    public static final String ACTION_CANCEL = "cancel";
    private final HttpClient _httpClient;
    private final List<String> _slaveEndpoints;

    public HttpClusterManager(List<String> slaveEndpoints) {
        this((HttpClient)new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager()), slaveEndpoints);
    }

    public HttpClusterManager(HttpClient httpClient, List<String> slaveEndpoints) {
        this._httpClient = httpClient;
        this._slaveEndpoints = slaveEndpoints;
    }

    @Override
    public JobDivisionManager getJobDivisionManager() {
        return new FixedDivisionsCountJobDivisionManager(this._slaveEndpoints.size());
    }

    @Override
    public AnalysisResultFuture dispatchJob(AnalysisJob job, DistributedJobContext context) throws Exception {
        int index = context.getJobDivisionIndex();
        final String slaveEndpoint = this._slaveEndpoints.get(index);
        JaxbJobWriter jobWriter = new JaxbJobWriter(context.getMasterConfiguration());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jobWriter.write(job, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        final LinkedList<Throwable> errors = new LinkedList<Throwable>();
        final String slaveJobUuid = UUID.randomUUID().toString();
        LazyRef<AnalysisResult> resultRef = this.sendExecuteRequest(slaveEndpoint, bytes, errors, slaveJobUuid);
        resultRef.requestLoad((Action)new Action<Throwable>(){

            public void run(Throwable error) throws Exception {
                errors.add(error);
            }
        });
        return new LazyRefAnalysisResultFuture(resultRef, errors){

            @Override
            public void cancel() {
                HttpClusterManager.this.sendCancelRequest(slaveEndpoint, slaveJobUuid);
            }
        };
    }

    private LazyRef<AnalysisResult> sendExecuteRequest(final String slaveEndpoint, final byte[] bytes, final List<Throwable> errors, final String slaveJobId) {
        return new LazyRef<AnalysisResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected AnalysisResult fetch() throws Throwable {
                AnalysisResult analysisResult;
                HttpPost request = new HttpPost(slaveEndpoint);
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair(HttpClusterManager.HTTP_PARAM_SLAVE_JOB_ID, slaveJobId));
                parameters.add(new BasicNameValuePair(HttpClusterManager.HTTP_PARAM_ACTION, HttpClusterManager.ACTION_RUN));
                parameters.add(new BasicNameValuePair(HttpClusterManager.HTTP_PARAM_JOB_DEF, new String(bytes)));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);
                request.setEntity((HttpEntity)entity);
                logger.info("Firing run request to slave server '{}' for job id '{}'", (Object)slaveEndpoint, (Object)slaveJobId);
                HttpResponse response = HttpClusterManager.this._httpClient.execute((HttpUriRequest)request);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    throw new IllegalStateException("Slave server '" + slaveEndpoint + "' responded with an error to 'run' request: " + statusLine.getReasonPhrase() + " (" + statusLine.getStatusCode() + ")");
                }
                InputStream inputStream = response.getEntity().getContent();
                try {
                    AnalysisResult result;
                    analysisResult = result = HttpClusterManager.this.readResult(inputStream, errors);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                return analysisResult;
            }
        };
    }

    private void sendCancelRequest(String slaveEndpoint, String slaveJobId) {
        HttpPost request = new HttpPost(slaveEndpoint);
        request.getParams().setParameter(HTTP_PARAM_SLAVE_JOB_ID, (Object)slaveJobId);
        request.getParams().setParameter(HTTP_PARAM_ACTION, (Object)ACTION_CANCEL);
        try {
            HttpResponse response = this._httpClient.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new IllegalStateException("Slave server '" + slaveEndpoint + "' responded with an error to 'cancel' request: " + statusLine.getReasonPhrase() + " (" + statusLine.getStatusCode() + ")");
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Failed to fire cancel request to slave server '" + slaveEndpoint + "' for job id '" + slaveJobId + "'", e);
        }
    }

    protected AnalysisResult readResult(InputStream inputStream, List<Throwable> errors) throws Exception {
        ChangeAwareObjectInputStream changeAwareObjectInputStream = new ChangeAwareObjectInputStream(inputStream);
        Object object = changeAwareObjectInputStream.readObject();
        changeAwareObjectInputStream.close();
        if (object instanceof AnalysisResult) {
            return (AnalysisResult)object;
        }
        if (object instanceof List) {
            List slaveErrors = (List)object;
            errors.addAll(slaveErrors);
            return null;
        }
        throw new IllegalStateException("Unexpected response payload: " + object);
    }
}

