/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.SerializationUtils;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.cluster.SlaveAnalysisRunner;
import org.datacleaner.cluster.SlaveJobInterceptor;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.JaxbJobReader;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.result.SimpleAnalysisResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaveServletHelper {
    private static final Logger logger = LoggerFactory.getLogger(SlaveServletHelper.class);
    private final DataCleanerConfiguration _configuration;
    private final SlaveJobInterceptor _jobInterceptor;
    private final ConcurrentMap<String, AnalysisResultFuture> _runningJobs;

    @Deprecated
    public SlaveServletHelper(DataCleanerConfiguration configuration) {
        this(configuration, new ConcurrentHashMap<String, AnalysisResultFuture>());
    }

    public SlaveServletHelper(DataCleanerConfiguration configuration, ConcurrentMap<String, AnalysisResultFuture> runningJobsMap) {
        this(configuration, null, runningJobsMap);
    }

    @Deprecated
    public SlaveServletHelper(DataCleanerConfiguration configuration, SlaveJobInterceptor jobInterceptor) {
        this(configuration, jobInterceptor, new ConcurrentHashMap<String, AnalysisResultFuture>());
    }

    public SlaveServletHelper(DataCleanerConfiguration configuration, SlaveJobInterceptor jobInterceptor, ConcurrentMap<String, AnalysisResultFuture> runningJobsMap) {
        if (configuration == null) {
            throw new IllegalArgumentException("DataCleanerConfiguration cannot be null");
        }
        this._configuration = configuration;
        this._jobInterceptor = jobInterceptor;
        this._runningJobs = runningJobsMap;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response, new AnalysisListener[0]);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response, AnalysisListener ... analysisListeners) throws IOException {
        String jobId = request.getParameter("slave-job-id");
        String action = request.getParameter("action");
        if ("cancel".equals(action)) {
            logger.info("Handling 'cancel' request: {}", (Object)jobId);
            this.cancelJob(jobId);
            return;
        }
        if ("run".equals(action)) {
            Serializable resultObject;
            AnalysisJob job;
            logger.info("Handling 'run' request: {}", (Object)jobId);
            try {
                job = this.readJob(request);
            }
            catch (IOException e) {
                logger.error("Failed to read job definition from HTTP request", (Throwable)e);
                throw e;
            }
            try {
                AnalysisResultFuture resultFuture = this.runJob(job, jobId, analysisListeners);
                resultObject = this.serializeResult(resultFuture, jobId);
            }
            catch (RuntimeException e) {
                logger.error("Unexpected error occurred while running slave job", (Throwable)e);
                throw e;
            }
            try {
                this.sendResponse(response, resultObject);
            }
            catch (IOException e) {
                logger.error("Failed to send job result through HTTP response", (Throwable)e);
                throw e;
            }
            return;
        }
        logger.warn("Unspecified action request: {}", (Object)jobId);
    }

    @Deprecated
    public Serializable serializeResult(AnalysisResultFuture resultFuture) {
        return this.serializeResult(resultFuture, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable serializeResult(AnalysisResultFuture resultFuture, String slaveJobId) {
        try {
            resultFuture.await();
            Object resultObject = resultFuture.isSuccessful() ? new SimpleAnalysisResult(resultFuture.getResultMap()) : new ArrayList(resultFuture.getErrors());
            Object object = resultObject;
            return object;
        }
        finally {
            if (slaveJobId != null) {
                this._runningJobs.remove(slaveJobId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisJob readJob(HttpServletRequest request) throws IOException {
        AnalysisJob analysisJob;
        JaxbJobReader reader = new JaxbJobReader(this._configuration);
        String jobDefinition = request.getParameter("job-def");
        Object inputStream = jobDefinition == null ? request.getInputStream() : new ByteArrayInputStream(jobDefinition.getBytes());
        try {
            AnalysisJob job;
            AnalysisJobBuilder jobBuilder = reader.create((InputStream)inputStream);
            if (this._jobInterceptor != null) {
                this._jobInterceptor.intercept(jobBuilder, this._configuration);
            }
            analysisJob = job = jobBuilder.toAnalysisJob();
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return analysisJob;
    }

    @Deprecated
    public AnalysisResultFuture runJob(AnalysisJob job) {
        return this.runJob(job, null);
    }

    public AnalysisResultFuture runJob(AnalysisJob job, String slaveJobId) {
        return this.runJob(job, slaveJobId, new AnalysisListener[0]);
    }

    public AnalysisResultFuture runJob(AnalysisJob job, String slaveJobId, AnalysisListener ... analysisListeners) {
        SlaveAnalysisRunner runner = new SlaveAnalysisRunner(this._configuration, analysisListeners);
        AnalysisResultFuture resultFuture = runner.run(job);
        if (slaveJobId != null) {
            this._runningJobs.put(slaveJobId, resultFuture);
        }
        return resultFuture;
    }

    public boolean cancelJob(String slaveJobId) {
        AnalysisResultFuture resultFuture = (AnalysisResultFuture)this._runningJobs.remove(slaveJobId);
        if (resultFuture != null) {
            resultFuture.cancel();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(HttpServletResponse response, Serializable object) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            SerializationUtils.serialize((Serializable)object, (OutputStream)outputStream);
        }
        finally {
            outputStream.flush();
        }
    }
}

