/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.cluster.AnalysisResultReductionException;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.AnalyzerJobHelper;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.CollectionUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DistributedAnalysisResultReducer {
    private static final Logger logger = LoggerFactory.getLogger(DistributedAnalysisResultReducer.class);
    private final AnalysisJob _masterJob;
    private final LifeCycleHelper _lifeCycleHelper;
    private final RowProcessingPublisher _publisher;
    private final AnalysisListener _analysisListener;
    private final AtomicBoolean _hasRun;

    public DistributedAnalysisResultReducer(AnalysisJob masterJob, LifeCycleHelper lifeCycleHelper, RowProcessingPublisher publisher, AnalysisListener analysisListener) {
        this._masterJob = masterJob;
        this._lifeCycleHelper = lifeCycleHelper;
        this._publisher = publisher;
        this._analysisListener = analysisListener;
        this._hasRun = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduce(List<AnalysisResultFuture> results, Map<ComponentJob, AnalyzerResult> resultMap, List<AnalysisResultReductionException> reductionErrors) {
        int size = results.size();
        try {
            logger.debug("Starting reduce phase of {} results", (Object)size);
            this.reduceResults(results, resultMap, reductionErrors);
            logger.debug("Finished reduce phase of {} results", (Object)size);
        }
        finally {
            this.closeNonDistributableComponents();
        }
    }

    private void closeNonDistributableComponents() {
        this._publisher.closeConsumers();
    }

    private void reduceResults(List<AnalysisResultFuture> results, Map<ComponentJob, AnalyzerResult> resultMap, List<AnalysisResultReductionException> reductionErrors) {
        if (this._hasRun.get()) {
            return;
        }
        this._hasRun.set(true);
        for (AnalysisResultFuture result : results) {
            if (!result.isErrornous()) continue;
            logger.error("Encountered errorneous slave result. Result reduction will stop. Result={}", (Object)result);
            List errors = result.getErrors();
            if (!errors.isEmpty()) {
                Throwable firstError = (Throwable)errors.get(0);
                logger.error("Encountered error before reducing results (showing stack trace of invoking the reducer): " + firstError.getMessage(), new Throwable());
                this._analysisListener.errorUnknown(this._masterJob, firstError);
            }
            return;
        }
        List analyzerJobs = this._masterJob.getAnalyzerJobs();
        for (AnalyzerJob masterAnalyzerJob : analyzerJobs) {
            ArrayList<AnalyzerResult> slaveResults = new ArrayList<AnalyzerResult>();
            logger.info("Reducing {} slave results for component: {}", (Object)results.size(), (Object)masterAnalyzerJob);
            for (AnalysisResultFuture result : results) {
                Map slaveResultMap = result.getResultMap();
                List slaveAnalyzerJobs = CollectionUtils2.filterOnClass(slaveResultMap.keySet(), AnalyzerJob.class);
                AnalyzerJobHelper analyzerJobHelper = new AnalyzerJobHelper((Collection)slaveAnalyzerJobs);
                AnalyzerJob slaveAnalyzerJob = analyzerJobHelper.getAnalyzerJob(masterAnalyzerJob);
                if (slaveAnalyzerJob == null) {
                    throw new IllegalStateException("Could not resolve slave component matching [" + masterAnalyzerJob + "] in slave result: " + result);
                }
                AnalyzerResult analyzerResult = result.getResult((ComponentJob)slaveAnalyzerJob);
                slaveResults.add(analyzerResult);
            }
            this.reduce(masterAnalyzerJob, slaveResults, resultMap, reductionErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduce(AnalyzerJob analyzerJob, Collection<AnalyzerResult> slaveResults, Map<ComponentJob, AnalyzerResult> resultMap, List<AnalysisResultReductionException> reductionErrors) {
        if (slaveResults.size() == 1) {
            AnalyzerResult firstResult = slaveResults.iterator().next();
            resultMap.put((ComponentJob)analyzerJob, firstResult);
            this._analysisListener.componentSuccess(this._masterJob, (ComponentJob)analyzerJob, firstResult);
            return;
        }
        Class reducerClass = analyzerJob.getDescriptor().getResultReducerClass();
        ComponentDescriptor reducerDescriptor = Descriptors.ofComponent((Class)reducerClass);
        AnalyzerResultReducer reducer = null;
        boolean success = false;
        try {
            reducer = (AnalyzerResultReducer)reducerDescriptor.newInstance();
            this._lifeCycleHelper.assignProvidedProperties(reducerDescriptor, (Object)reducer);
            this._lifeCycleHelper.initialize(reducerDescriptor, (Object)reducer);
            AnalyzerResult reducedResult = reducer.reduce(slaveResults);
            resultMap.put((ComponentJob)analyzerJob, reducedResult);
            success = true;
            this._analysisListener.componentSuccess(this._masterJob, (ComponentJob)analyzerJob, reducedResult);
        }
        catch (Exception e) {
            AnalysisResultReductionException reductionError = new AnalysisResultReductionException(analyzerJob, slaveResults, e);
            reductionErrors.add(reductionError);
            this._analysisListener.errorInComponent(this._masterJob, (ComponentJob)analyzerJob, null, (Throwable)e);
        }
        finally {
            if (reducer != null) {
                this._lifeCycleHelper.close(reducerDescriptor, (Object)reducer, success);
            }
        }
    }
}

