/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.metamodel.util.LazyRef;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobFailedException;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.JobStatus;
import org.datacleaner.result.AnalysisResult;

public class LazyRefAnalysisResultFuture
implements AnalysisResultFuture {
    private final LazyRef<AnalysisResult> _resultRef;
    private final List<Throwable> _errors;

    public LazyRefAnalysisResultFuture(LazyRef<AnalysisResult> resultRef, List<Throwable> errors) {
        this._resultRef = resultRef;
        this._errors = errors;
    }

    public boolean isErrornous() {
        return this.getStatus() == JobStatus.ERRORNOUS;
    }

    public boolean isCancelled() {
        return false;
    }

    public Date getCreationDate() {
        AnalysisResult analysisResult = (AnalysisResult)this._resultRef.get();
        if (analysisResult == null) {
            return null;
        }
        return analysisResult.getCreationDate();
    }

    public boolean isDone() {
        return this._resultRef.isFetched();
    }

    public void await() {
        this._resultRef.get();
    }

    public void cancel() {
        throw new UnsupportedOperationException("Cancel not supported for slave jobs");
    }

    public void await(long timeout, TimeUnit timeUnit) {
        long offsetMillis = System.currentTimeMillis();
        long millisToWait = timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
        long sleepInterval = millisToWait % 1000L == 0L ? 1000 : 500;
        while (!this.isDone()) {
            long currentMillis;
            long duration;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((duration = (currentMillis = System.currentTimeMillis()) - offsetMillis) < millisToWait) continue;
            return;
        }
    }

    public boolean isSuccessful() {
        return this.getStatus() == JobStatus.SUCCESSFUL;
    }

    public JobStatus getStatus() {
        if (!this._resultRef.isFetched()) {
            return JobStatus.NOT_FINISHED;
        }
        if (this._errors.isEmpty()) {
            return JobStatus.SUCCESSFUL;
        }
        return JobStatus.ERRORNOUS;
    }

    public List<AnalyzerResult> getResults() throws AnalysisJobFailedException {
        AnalysisResult analysisResult = (AnalysisResult)this._resultRef.get();
        if (analysisResult == null) {
            return null;
        }
        return analysisResult.getResults();
    }

    public AnalyzerResult getResult(ComponentJob componentJob) throws AnalysisJobFailedException {
        AnalysisResult analysisResult = (AnalysisResult)this._resultRef.get();
        if (analysisResult == null) {
            return null;
        }
        return ((AnalysisResult)this._resultRef.get()).getResult(componentJob);
    }

    public Map<ComponentJob, AnalyzerResult> getResultMap() throws AnalysisJobFailedException {
        AnalysisResult analysisResult = (AnalysisResult)this._resultRef.get();
        if (analysisResult == null) {
            return null;
        }
        return ((AnalysisResult)this._resultRef.get()).getResultMap();
    }

    public List<Throwable> getErrors() {
        return Collections.unmodifiableList(this._errors);
    }

    public <R extends AnalyzerResult> List<? extends R> getResults(Class<R> resultClass) {
        return ((AnalysisResult)this._resultRef.get()).getResults(resultClass);
    }
}

