/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster.http;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.datacleaner.cluster.http.SlaveServletHelper;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;

public class SlaveServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_CONTEXT_ATTRIBUTE_CONFIGURATION = "org.datacleaner.configuration";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_ANALYSIS_LISTENER = "org.datacleaner.analysislistener";
    @Inject
    DataCleanerConfiguration _configuration;
    @Inject
    AnalysisListener _analysisListener;
    private final ConcurrentMap<String, AnalysisResultFuture> _runningJobs;

    public SlaveServlet() {
        this(null);
    }

    public SlaveServlet(DataCleanerConfiguration configuration) {
        this(configuration, null);
    }

    public SlaveServlet(DataCleanerConfiguration configuration, AnalysisListener analysisListener) {
        this._configuration = configuration;
        this._analysisListener = analysisListener;
        this._runningJobs = new ConcurrentHashMap<String, AnalysisResultFuture>();
    }

    public void init(ServletConfig config) throws ServletException {
        Object analysisListenerAttribute;
        Object configurationAttribute;
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        if (this._configuration == null && (configurationAttribute = servletContext.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONFIGURATION)) != null && configurationAttribute instanceof DataCleanerConfiguration) {
            this._configuration = (DataCleanerConfiguration)configurationAttribute;
        }
        if (this._analysisListener == null && (analysisListenerAttribute = servletContext.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_ANALYSIS_LISTENER)) != null && analysisListenerAttribute instanceof AnalysisListener) {
            this._analysisListener = (AnalysisListener)analysisListenerAttribute;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SlaveServletHelper helper = new SlaveServletHelper(this._configuration, this._runningJobs);
        if (this._analysisListener == null) {
            helper.handleRequest(req, resp);
        } else {
            helper.handleRequest(req, resp, this._analysisListener);
        }
    }
}

