/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.cluster.virtual;

import org.datacleaner.cluster.ClusterManager;
import org.datacleaner.cluster.DistributedJobContext;
import org.datacleaner.cluster.FixedDivisionsCountJobDivisionManager;
import org.datacleaner.cluster.JobDivisionManager;
import org.datacleaner.cluster.SlaveAnalysisRunner;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.runner.AnalysisResultFuture;

public class VirtualClusterManager
implements ClusterManager {
    private final DataCleanerConfiguration _configuration;
    private final int _nodeCount;

    public VirtualClusterManager(DataCleanerConfiguration configuration, int nodeCount) {
        this._configuration = configuration;
        this._nodeCount = nodeCount;
    }

    @Override
    public AnalysisResultFuture dispatchJob(AnalysisJob job, DistributedJobContext context) {
        SlaveAnalysisRunner runner = new SlaveAnalysisRunner(this._configuration);
        return runner.run(job);
    }

    @Override
    public JobDivisionManager getJobDivisionManager() {
        return new FixedDivisionsCountJobDivisionManager(this._nodeCount);
    }
}

