/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.group;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.metamodel.util.AggregateBuilder;
import org.apache.metamodel.util.ObjectComparator;
import org.datacleaner.components.group.SortationType;

abstract class AbstractRowNumberAwareAggregateBuilder<T>
implements AggregateBuilder<T> {
    private final SortationType _sortationType;
    private final Object _values;
    private final boolean _skipNulls;

    public AbstractRowNumberAwareAggregateBuilder(SortationType sortationType, boolean skipNulls) {
        this._sortationType = sortationType;
        this._skipNulls = skipNulls;
        switch (sortationType) {
            case NONE: {
                this._values = null;
                break;
            }
            case NATURAL_SORT_ASC: {
                this._values = new TreeSet(ObjectComparator.getComparator());
                break;
            }
            case NATURAL_SORT_DESC: {
                this._values = new TreeSet(Collections.reverseOrder(ObjectComparator.getComparator()));
                break;
            }
            case RECORD_ORDER: {
                this._values = new TreeMap();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public final void add(Object o) {
        throw new UnsupportedOperationException();
    }

    public final void add(Object o, long rowNumber) {
        if (this._skipNulls && o == null) {
            return;
        }
        switch (this._sortationType) {
            case NONE: {
                this.addSorted(o);
                break;
            }
            case NATURAL_SORT_ASC: 
            case NATURAL_SORT_DESC: {
                Collection collection = (Collection)this._values;
                collection.add(o);
                break;
            }
            case RECORD_ORDER: {
                Map map = (Map)this._values;
                map.put(rowNumber, o);
            }
        }
    }

    public final T getAggregate() {
        switch (this._sortationType) {
            case NONE: {
                break;
            }
            case NATURAL_SORT_ASC: 
            case NATURAL_SORT_DESC: {
                Collection collection = (Collection)this._values;
                for (Object o : collection) {
                    this.addSorted(o);
                }
                break;
            }
            case RECORD_ORDER: {
                Map map = (Map)this._values;
                Collection objects = map.values();
                for (Object o : objects) {
                    this.addSorted(o);
                }
                break;
            }
        }
        return this.getAggregateSorted();
    }

    protected abstract T getAggregateSorted();

    protected abstract void addSorted(Object var1);
}

