/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.AggregateBuilder;
import org.apache.metamodel.util.HasName;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Close;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.MultiStreamComponent;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.components.categories.CompositionCategory;
import org.datacleaner.components.group.AbstractRowNumberAwareAggregateBuilder;
import org.datacleaner.components.group.ConcatAggregateBuilder;
import org.datacleaner.components.group.CreateListAggregateBuilder;
import org.datacleaner.components.group.SortationType;
import org.datacleaner.job.output.OutputDataStreamBuilder;
import org.datacleaner.job.output.OutputDataStreams;

@Named(value="Grouper")
@Description(value="A component that allows grouping and aggregating values with the same key.")
@Categorized(value={CompositionCategory.class})
@Distributed(value=false)
public class GrouperTransformer
extends MultiStreamComponent {
    public static final String PROPERTY_GROUP_KEY = "Group key";
    public static final String PROPERTY_AGGREGATED_VALUES = "Aggregated values";
    public static final String PROPERTY_AGGREGATION_TYPES = "AggregationTypes";
    public static final String PROPERTY_VALUE_SORTATION = "Value sortation";
    private static final Object NULL_KEY = new Object();
    @Configured(order=1, value="Group key")
    InputColumn<?> groupKey;
    @Configured(order=2, value="Aggregated values")
    InputColumn<?>[] aggregatedValues;
    @Configured(order=3, value="AggregationTypes")
    @MappedProperty(value="Aggregated values")
    AggregationType[] aggregationTypes;
    @Configured(order=4, value="Value sortation")
    SortationType valueSortation = SortationType.NONE;
    @Configured
    String concatenationSeparator = ", ";
    @Configured
    boolean skipNullGroupKeys = true;
    @Configured
    boolean skipNullValues = true;
    private final ConcurrentMap<Object, List<AggregateBuilder<?>>> _aggregateBuilders = new ConcurrentHashMap();
    private OutputRowCollector _rowCollector;

    @Initialize
    public void init() {
        this._aggregateBuilders.clear();
    }

    public OutputDataStream[] getOutputDataStreams() {
        OutputDataStreamBuilder outputDataStreamBuilder = OutputDataStreams.pushDataStream((String)"output");
        outputDataStreamBuilder.withColumnLike(this.groupKey);
        outputDataStreamBuilder.withColumn("row_count", ColumnType.INTEGER);
        for (int i = 0; i < this.aggregatedValues.length; ++i) {
            AggregationType aggregationType;
            InputColumn<?> inputColumn = this.aggregatedValues[i];
            AggregationType aggregationType2 = aggregationType = this.aggregationTypes.length <= i ? AggregationType.CREATE_LIST : this.aggregationTypes[i];
            if (aggregationType == null) continue;
            aggregationType.addColumnToOutputStream(outputDataStreamBuilder, inputColumn);
        }
        OutputDataStream stream = outputDataStreamBuilder.toOutputDataStream();
        return new OutputDataStream[]{stream};
    }

    public void initializeOutputDataStream(OutputDataStream stream, Query q, OutputRowCollector collector) {
        this._rowCollector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(InputRow row) {
        if (this._rowCollector == null) {
            return;
        }
        Object key = row.getValue(this.groupKey);
        if (key == null) {
            if (this.skipNullGroupKeys) {
                return;
            }
            key = NULL_KEY;
        }
        List<AggregateBuilder<?>> aggregateBuilders = this.getAggregateBuilders(key);
        long rowId = row.getId();
        aggregateBuilders.get(0).add((Object)rowId);
        for (int i = 0; i < this.aggregatedValues.length; ++i) {
            AggregateBuilder<?> aggregateBuilder;
            Object value = row.getValue(this.aggregatedValues[i]);
            AggregateBuilder<?> aggregateBuilder2 = aggregateBuilder = aggregateBuilders.get(i + 1);
            synchronized (aggregateBuilder2) {
                if (aggregateBuilder instanceof AbstractRowNumberAwareAggregateBuilder) {
                    ((AbstractRowNumberAwareAggregateBuilder)aggregateBuilder).add(value, rowId);
                } else {
                    aggregateBuilder.add(value);
                }
                continue;
            }
        }
    }

    private List<AggregateBuilder<?>> getAggregateBuilders(Object key) {
        List<Object> collectionOfAggregateBuilders = (ArrayList<Object>)this._aggregateBuilders.get(key);
        if (collectionOfAggregateBuilders == null) {
            ArrayList<Object> newCollectionOfValues = new ArrayList<Object>(this.aggregationTypes.length);
            newCollectionOfValues.add(FunctionType.COUNT.createAggregateBuilder());
            for (AggregationType aggregationType : this.aggregationTypes) {
                AggregateBuilder<?> aggregateBuilder = aggregationType.createAggregateBuilder(this.valueSortation, this.skipNullValues, this.concatenationSeparator);
                newCollectionOfValues.add(aggregateBuilder);
            }
            List previousCollectionOfValues = this._aggregateBuilders.putIfAbsent(key, newCollectionOfValues);
            collectionOfAggregateBuilders = previousCollectionOfValues == null ? newCollectionOfValues : previousCollectionOfValues;
        }
        return collectionOfAggregateBuilders;
    }

    @Close
    public void close() {
        Set entrySet = this._aggregateBuilders.entrySet();
        for (Map.Entry entry : entrySet) {
            Object key = entry.getKey();
            List aggregateBuilders = (List)entry.getValue();
            Object[] values = new Object[2 + this.aggregatedValues.length];
            values[0] = key == NULL_KEY ? null : key;
            values[1] = ((AggregateBuilder)aggregateBuilders.get(0)).getAggregate();
            for (int i = 1; i < aggregateBuilders.size(); ++i) {
                AggregateBuilder aggregateBuilder = (AggregateBuilder)aggregateBuilders.get(i);
                values[i + 1] = aggregateBuilder.getAggregate();
            }
            this._rowCollector.putValues(values);
        }
    }

    public static enum AggregationType implements HasName
    {
        CONCAT_VALUES("Concatenate values"),
        FIRST_VALUE("Select first value"),
        LAST_VALUE("Select last value"),
        RANDOM_VALUE("Select random value"),
        CREATE_LIST("Create list of values"),
        SUM("Calculate sum"),
        AVG("Calculate average");

        private final String _name;

        private AggregationType(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public AggregateBuilder<?> createAggregateBuilder(SortationType sortationType, boolean skipNulls, String concatenationSeparator) {
            switch (this) {
                case CONCAT_VALUES: {
                    return new ConcatAggregateBuilder(sortationType, skipNulls, concatenationSeparator);
                }
                case CREATE_LIST: {
                    return new CreateListAggregateBuilder(sortationType, skipNulls);
                }
                case FIRST_VALUE: {
                    return FunctionType.FIRST.createAggregateBuilder();
                }
                case LAST_VALUE: {
                    return FunctionType.LAST.createAggregateBuilder();
                }
                case SUM: {
                    return FunctionType.SUM.createAggregateBuilder();
                }
                case AVG: {
                    return FunctionType.AVG.createAggregateBuilder();
                }
                case RANDOM_VALUE: {
                    return FunctionType.RANDOM.createAggregateBuilder();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void addColumnToOutputStream(OutputDataStreamBuilder outputDataStreamBuilder, InputColumn<?> inputColumn) {
            switch (this) {
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case RANDOM_VALUE: {
                    outputDataStreamBuilder.withColumnLike(inputColumn);
                    break;
                }
                case SUM: 
                case AVG: {
                    outputDataStreamBuilder.withColumn(inputColumn.getName(), ColumnType.NUMBER);
                    break;
                }
                case CONCAT_VALUES: {
                    outputDataStreamBuilder.withColumn(inputColumn.getName(), ColumnType.STRING);
                    break;
                }
                case CREATE_LIST: {
                    outputDataStreamBuilder.withColumn(inputColumn.getName(), ColumnType.LIST);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation type: " + (Object)((Object)this));
                }
            }
        }
    }
}

