/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.html;

import java.util.List;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Renderable;
import org.datacleaner.api.Renderer;
import org.datacleaner.result.html.BodyElement;
import org.datacleaner.result.html.HeadElement;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.HtmlRenderingContext;
import org.datacleaner.result.renderer.HtmlRenderingFormat;
import org.datacleaner.result.renderer.RendererFactory;

public class DrillToDetailsBodyElement
implements BodyElement {
    private final AnalyzerResult _result;
    private final String _elementId;
    private final RendererFactory _rendererFactory;

    public DrillToDetailsBodyElement(String elementId, RendererFactory rendererFactory, AnalyzerResult result) {
        if (rendererFactory == null) {
            throw new IllegalArgumentException("RendererFactory cannot be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("AnalyzerResult cannot be null");
        }
        this._elementId = elementId;
        this._rendererFactory = rendererFactory;
        this._result = result;
    }

    @Override
    public String toHtml(HtmlRenderingContext context) {
        Renderer renderer = this._rendererFactory.getRenderer((Renderable)this._result, HtmlRenderingFormat.class);
        if (renderer == null) {
            throw new IllegalStateException("No renderer found for: " + this._result);
        }
        HtmlFragment htmlFragment = (HtmlFragment)renderer.render((Renderable)this._result);
        htmlFragment.initialize(context);
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"" + this._elementId + "\" class=\"drillToDetailsPanel\" style=\"display:none;\">\n");
        List<HeadElement> headElements = htmlFragment.getHeadElements();
        for (HeadElement headElement : headElements) {
            sb.append(headElement);
            sb.append('\n');
        }
        List<BodyElement> bodyElements = htmlFragment.getBodyElements();
        for (BodyElement bodyElement : bodyElements) {
            sb.append(bodyElement.toHtml(context));
            sb.append('\n');
        }
        sb.append("</div>");
        return sb.toString();
    }

    public String toJavaScriptInvocation() {
        return "drillToDetails('" + this._elementId + "'); return false;";
    }
}

