/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.metamodel.util.Predicate;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.TruePredicate;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Renderable;
import org.datacleaner.api.Renderer;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.result.AnalysisResult;
import org.datacleaner.result.AnalysisResultWriter;
import org.datacleaner.result.html.BaseHeadElement;
import org.datacleaner.result.html.BodyElement;
import org.datacleaner.result.html.ComponentHtmlRenderingContext;
import org.datacleaner.result.html.DefaultHtmlRenderingContext;
import org.datacleaner.result.html.HeadElement;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.HtmlRenderingContext;
import org.datacleaner.result.renderer.HtmlRenderingFormat;
import org.datacleaner.result.renderer.RendererFactory;
import org.datacleaner.util.ComponentJobComparator;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAnalysisResultWriter
implements AnalysisResultWriter {
    private static final Logger logger = LoggerFactory.getLogger(HtmlAnalysisResultWriter.class);
    private final boolean _tabs;
    private final boolean _headers;
    private final Predicate<Map.Entry<ComponentJob, AnalyzerResult>> _jobInclusionPredicate;

    public HtmlAnalysisResultWriter() {
        this(true);
    }

    public HtmlAnalysisResultWriter(boolean tabs) {
        this(tabs, (Predicate<Map.Entry<ComponentJob, AnalyzerResult>>)new TruePredicate());
    }

    public HtmlAnalysisResultWriter(boolean tabs, Predicate<Map.Entry<ComponentJob, AnalyzerResult>> jobInclusionPredicate) {
        this(tabs, jobInclusionPredicate, true);
    }

    public HtmlAnalysisResultWriter(boolean tabs, Predicate<Map.Entry<ComponentJob, AnalyzerResult>> jobInclusionPredicate, boolean headers) {
        this._tabs = tabs;
        this._jobInclusionPredicate = jobInclusionPredicate;
        this._headers = headers;
    }

    public void write(AnalysisResult result, DataCleanerConfiguration configuration, Ref<Writer> writerRef, Ref<OutputStream> outputStreamRef) throws IOException {
        Writer writer = (Writer)writerRef.get();
        this.write(result, configuration, writer);
    }

    public void write(AnalysisResult result, DataCleanerConfiguration configuration, Writer writer) throws IOException {
        DefaultHtmlRenderingContext context = new DefaultHtmlRenderingContext();
        RendererFactory rendererFactory = new RendererFactory(configuration);
        LinkedHashMap<ComponentJob, HtmlFragment> htmlFragments = new LinkedHashMap<ComponentJob, HtmlFragment>();
        TreeMap resultMap = new TreeMap(new ComponentJobComparator());
        resultMap.putAll(result.getResultMap());
        for (Map.Entry entry : resultMap.entrySet()) {
            ComponentJob componentJob = (ComponentJob)entry.getKey();
            AnalyzerResult analyzerResult = (AnalyzerResult)entry.getValue();
            if (((Boolean)this._jobInclusionPredicate.eval(entry)).booleanValue()) {
                Renderer renderer = rendererFactory.getRenderer((Renderable)analyzerResult, HtmlRenderingFormat.class);
                if (renderer == null) {
                    throw new IllegalStateException("No HTML renderer found for result: " + analyzerResult);
                }
                ComponentHtmlRenderingContext localContext = new ComponentHtmlRenderingContext(context, componentJob);
                try {
                    HtmlFragment htmlFragment = (HtmlFragment)renderer.render((Renderable)analyzerResult);
                    htmlFragment.initialize(localContext);
                    htmlFragments.put(componentJob, htmlFragment);
                }
                catch (Exception e) {
                    logger.error("Error while rendering analyzer result: " + analyzerResult, (Throwable)e);
                    this.writeRenderingError(writer, componentJob, analyzerResult, e);
                }
                continue;
            }
            logger.debug("Skipping job {} / result {} because predicate evaluated false", (Object)componentJob, (Object)analyzerResult);
        }
        this.writeHtmlBegin(writer, context);
        this.writeHead(writer, htmlFragments, context);
        this.writeBody(writer, htmlFragments, context);
        this.writeHtmlEnd(writer, context);
    }

    private void writeMaterializationError(Writer writer, ComponentJob componentJob, Exception e) throws IOException {
        this.writeGenericError(writer, componentJob, null, e);
    }

    private void writeRenderingError(Writer writer, ComponentJob componentJob, AnalyzerResult analyzerResult, Exception e) throws IOException {
        this.writeGenericError(writer, componentJob, analyzerResult, e);
    }

    private void writeGenericError(Writer writer, ComponentJob componentJob, AnalyzerResult analyzerResult, Exception e) throws IOException {
        writer.write("<div class=\"error\">");
        writer.write("<p>Component job: " + LabelUtils.getLabel((ComponentJob)componentJob) + "</p>");
        if (analyzerResult != null) {
            writer.write("<p>Analyzer result: " + analyzerResult + "</p>");
        }
        writer.write("<pre>");
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        writer.write("</pre>");
        writer.write("</div>");
    }

    protected void writeHtmlBegin(Writer writer, HtmlRenderingContext context) throws IOException {
        writer.write("<!DOCTYPE html>\n");
        writer.write("<html>\n");
    }

    protected void writeHtmlEnd(Writer writer, HtmlRenderingContext context) throws IOException {
        writer.write("</html>");
    }

    protected void writeHead(Writer writer, Map<ComponentJob, HtmlFragment> htmlFragments, HtmlRenderingContext context) throws IOException {
        HashSet<HeadElement> allHeadElements = new HashSet<HeadElement>();
        this.writeHeadBegin(writer);
        HeadElement baseHeadElement = this.createBaseHeadElement();
        this.writeHeadElement(writer, null, baseHeadElement, context);
        allHeadElements.add(baseHeadElement);
        for (Map.Entry<ComponentJob, HtmlFragment> entry : htmlFragments.entrySet()) {
            HtmlFragment htmlFragment = entry.getValue();
            List<HeadElement> headElements = htmlFragment.getHeadElements();
            for (HeadElement headElement : headElements) {
                if (allHeadElements.contains(headElement)) continue;
                ComponentJob componentJob = entry.getKey();
                this.writeHeadElement(writer, componentJob, headElement, context);
                allHeadElements.add(headElement);
            }
        }
        this.writeHeadEnd(writer);
    }

    protected HeadElement createBaseHeadElement() {
        return new BaseHeadElement();
    }

    protected void writeHeadBegin(Writer writer) throws IOException {
        writer.write("<head>\n");
        writer.write("  <title>Analysis result</title>");
    }

    protected void writeHeadEnd(Writer writer) throws IOException {
        writer.write("</head>");
    }

    protected void writeHeadElement(Writer writer, ComponentJob componentJob, HeadElement headElement, HtmlRenderingContext context) throws IOException {
        ComponentHtmlRenderingContext localContext = new ComponentHtmlRenderingContext(context, componentJob);
        writer.write("  ");
        try {
            String html = headElement.toHtml(localContext);
            writer.write(html);
        }
        catch (Exception e) {
            this.writeMaterializationError(writer, componentJob, e);
        }
        writer.write(10);
    }

    protected void writeBody(Writer writer, Map<ComponentJob, HtmlFragment> htmlFragments, HtmlRenderingContext context) throws IOException {
        Set<Map.Entry<ComponentJob, HtmlFragment>> htmlFragmentSet = htmlFragments.entrySet();
        this.writeBodyBegin(writer, context);
        writer.write("<div class=\"analysisResultHeader\">");
        if (this._tabs) {
            writer.write("<ul class=\"analysisResultToc\">");
            ComponentDescriptor lastDescriptor = null;
            for (Map.Entry<ComponentJob, HtmlFragment> entry : htmlFragmentSet) {
                ComponentJob componentJob = entry.getKey();
                ComponentDescriptor descriptor = componentJob.getDescriptor();
                if (descriptor.equals(lastDescriptor)) continue;
                String styleName = this.toStyleName(descriptor.getDisplayName());
                writer.write("<li class=\"" + styleName + "\"><a href=\"#analysisResultDescriptorGroup_" + styleName + "\">");
                writer.write(context.escapeHtml(descriptor.getDisplayName()));
                writer.write("</a></li>");
                lastDescriptor = descriptor;
            }
            writer.write("</ul>");
        }
        writer.write("</div>");
        boolean descriptorGroupBegin = false;
        ComponentDescriptor lastDescriptor = null;
        for (Map.Entry<ComponentJob, HtmlFragment> entry : htmlFragmentSet) {
            ComponentJob componentJob = entry.getKey();
            ComponentDescriptor descriptor = componentJob.getDescriptor();
            HtmlFragment htmlFragment = entry.getValue();
            if (!descriptor.equals(lastDescriptor)) {
                if (descriptorGroupBegin) {
                    writer.write("</div>\n");
                }
                String styleName = this.toStyleName(descriptor.getDisplayName());
                writer.write("<div id=\"analysisResultDescriptorGroup_" + styleName + "\" class=\"analysisResultDescriptorGroup " + this.toStyleName(descriptor.getDisplayName()) + "\">");
                lastDescriptor = descriptor;
                descriptorGroupBegin = true;
            }
            this.writeBodyHtmlFragment(writer, componentJob, htmlFragment, context);
        }
        if (descriptorGroupBegin) {
            writer.write("</div>\n");
        }
        this.writeBodyEnd(writer, context);
    }

    protected void writeBodyBegin(Writer writer, HtmlRenderingContext context) throws IOException {
        writer.write("<body>\n");
        writer.write("<div class=\"analysisResultContainer\">\n");
    }

    protected void writeBodyEnd(Writer writer, HtmlRenderingContext context) throws IOException {
        writer.write("</div>\n");
        writer.write("</body>");
    }

    protected void writeBodyHtmlFragment(Writer writer, ComponentJob componentJob, HtmlFragment htmlFragment, HtmlRenderingContext context) throws IOException {
        String displayName = componentJob.getDescriptor().getDisplayName();
        String styleName = this.toStyleName(displayName);
        writer.write("<div class=\"analyzerResult " + styleName + "\">");
        if (this._headers) {
            this.writeHeader(writer, componentJob, context, htmlFragment);
        }
        writer.write("<div class=\"analyzerResultContent\">\n");
        List<BodyElement> bodyElements = htmlFragment.getBodyElements();
        for (BodyElement bodyElement : bodyElements) {
            this.writeBodyElement(writer, componentJob, htmlFragment, bodyElement, context);
        }
        writer.write("</div>");
        writer.write("<div class=\"analyzerResultFooter\"></div>");
        writer.write("</div>\n");
    }

    protected void writeHeader(Writer writer, ComponentJob componentJob, HtmlRenderingContext context, HtmlFragment htmlFragment) throws IOException {
        String label = LabelUtils.getLabel((ComponentJob)componentJob);
        writer.write("<div class=\"analyzerResultHeader\">");
        writer.write("<h2>" + context.escapeHtml(label) + "</h2>");
        writer.write("</div>");
    }

    protected String toStyleName(String displayName) {
        String camelCase = StringUtils.toCamelCase((String)displayName);
        String cleaned = camelCase.replaceAll("/", "_").replaceAll("&", "_");
        return cleaned;
    }

    protected void writeBodyElement(Writer writer, ComponentJob componentJob, HtmlFragment htmlFragment, BodyElement bodyElement, HtmlRenderingContext context) throws IOException {
        ComponentHtmlRenderingContext localContext = new ComponentHtmlRenderingContext(context, componentJob);
        writer.write("  ");
        try {
            String html = bodyElement.toHtml(localContext);
            writer.write(html);
        }
        catch (Exception e) {
            this.writeMaterializationError(writer, componentJob, e);
        }
        writer.write(10);
    }
}

