/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import javax.swing.table.TableModel;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RendererPrecedence;
import org.datacleaner.result.AnnotatedRowsResult;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.SimpleHtmlFragment;
import org.datacleaner.result.renderer.HtmlRenderingFormat;
import org.datacleaner.result.renderer.SectionHeaderBodyElement;
import org.datacleaner.result.renderer.TableBodyElement;
import org.datacleaner.util.ReflectionUtils;

@RendererBean(value=HtmlRenderingFormat.class)
public class AnnotatedRowsHtmlRenderer
implements Renderer<AnnotatedRowsResult, HtmlFragment> {
    private static final int MAX_ROWS = 100;

    public RendererPrecedence getPrecedence(AnnotatedRowsResult renderable) {
        return RendererPrecedence.MEDIUM;
    }

    public HtmlFragment render(AnnotatedRowsResult result) {
        SimpleHtmlFragment htmlFragment = new SimpleHtmlFragment();
        InputColumn[] highlightedColumns = result.getHighlightedColumns();
        int[] highlightedIndexes = new int[highlightedColumns.length];
        for (int i = 0; i < highlightedColumns.length; ++i) {
            highlightedIndexes[i] = result.getColumnIndex(highlightedColumns[i]);
        }
        TableModel tableModel = result.toTableModel(100);
        Description description = (Description)ReflectionUtils.getAnnotation(result.getClass(), Description.class);
        String descriptionText = description != null ? description.value() : "Records";
        int rowCount = result.getAnnotatedRowCount();
        htmlFragment.addBodyElement(new SectionHeaderBodyElement(descriptionText + " (" + rowCount + ")"));
        if (rowCount == 0) {
            htmlFragment.addBodyElement("<p>No records to display.</p>");
        } else {
            htmlFragment.addBodyElement(new TableBodyElement(tableModel, "annotatedRowsTable", highlightedIndexes));
        }
        return htmlFragment;
    }
}

