/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import java.text.DecimalFormatSymbols;
import java.util.List;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.result.AnnotatedRowsResult;
import org.datacleaner.result.Crosstab;
import org.datacleaner.result.CrosstabDimension;
import org.datacleaner.result.ResultProducer;
import org.datacleaner.result.html.DrillToDetailsBodyElement;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.HtmlRenderingContext;
import org.datacleaner.result.html.SimpleHtmlFragment;
import org.datacleaner.result.renderer.CrosstabRendererCallback;
import org.datacleaner.result.renderer.RendererFactory;
import org.datacleaner.util.LabelUtils;

public class HtmlCrosstabRendererCallback
implements CrosstabRendererCallback<HtmlFragment> {
    private final StringBuilder sb;
    private final SimpleHtmlFragment htmlFragtment;
    private final RendererFactory rendererFactory;
    private final HtmlRenderingContext htmlRenderingContext;
    private int rowNumber;

    public HtmlCrosstabRendererCallback(RendererFactory rendererFactory, HtmlRenderingContext htmlRenderingContext) {
        this.rendererFactory = rendererFactory;
        this.htmlRenderingContext = htmlRenderingContext;
        this.sb = new StringBuilder();
        this.rowNumber = 0;
        this.htmlFragtment = new SimpleHtmlFragment();
    }

    public void beginTable(Crosstab<?> crosstab, List<CrosstabDimension> horizontalDimensions, List<CrosstabDimension> verticalDimensions) {
        this.sb.append("<table class=\"crosstabTable\">");
    }

    public void endTable() {
        this.sb.append("</table>");
    }

    public void beginRow() {
        ++this.rowNumber;
        if (this.rowNumber % 2 == 0) {
            this.sb.append("<tr class=\"even\">");
        } else {
            this.sb.append("<tr class=\"odd\">");
        }
    }

    public void endRow() {
        this.sb.append("</tr>");
    }

    public void horizontalHeaderCell(String category, CrosstabDimension dimension, int width) {
        if (width <= 0) {
            return;
        }
        if (width > 1) {
            this.sb.append("<td class=\"crosstabHorizontalHeader\" colspan=\"");
            this.sb.append(width);
            this.sb.append("\">");
        } else if (width == 1) {
            this.sb.append("<td class=\"crosstabHorizontalHeader\">");
        }
        this.sb.append(this.toHtml(category));
        this.sb.append("</td>");
    }

    public void verticalHeaderCell(String category, CrosstabDimension dimension, int height) {
        if (height <= 0) {
            return;
        }
        if (height > 1) {
            this.sb.append("<td class=\"crosstabVerticalHeader\" rowspan=\"");
            this.sb.append(height);
            this.sb.append("\">");
        } else if (height == 1) {
            this.sb.append("<td class=\"crosstabVerticalHeader\">");
        }
        this.sb.append(this.toHtml(category));
        this.sb.append("</td>");
    }

    public void valueCell(Object value, ResultProducer drillToDetailResultProducer) {
        if (drillToDetailResultProducer == null) {
            this.simpleValueCell(value);
            return;
        }
        AnalyzerResult drillResult = drillToDetailResultProducer.getResult();
        if (drillResult == null) {
            this.simpleValueCell(value);
            return;
        }
        if (drillResult instanceof AnnotatedRowsResult && ((AnnotatedRowsResult)drillResult).getAnnotatedRowCount() == 0) {
            this.simpleValueCell(value);
            return;
        }
        String drillElementId = this.htmlRenderingContext.createElementId();
        DrillToDetailsBodyElement drillBodyElement = new DrillToDetailsBodyElement(drillElementId, this.rendererFactory, drillResult);
        this.htmlFragtment.addBodyElement(drillBodyElement);
        String invocation = drillBodyElement.toJavaScriptInvocation();
        this.sb.append("<td class=\"value\">");
        this.sb.append("<a class=\"drillToDetailsLink\" href=\"#\" onclick=\"" + invocation + "\">");
        this.sb.append(this.toHtml(LabelUtils.getValueLabel((Object)value)));
        this.sb.append("</a>");
        this.sb.append("</td>");
    }

    private void simpleValueCell(Object value) {
        this.sb.append("<td class=\"value\">");
        this.sb.append(this.toHtml(value));
        this.sb.append("</td>");
    }

    public String toHtml(Object value) {
        DecimalFormatSymbols decimalFormatSymbols;
        char decimalSeparator;
        int indexOfDecimalSeparator;
        String valueLabel = LabelUtils.getValueLabel((Object)value);
        valueLabel = this.htmlRenderingContext.escapeHtml(valueLabel);
        if (value instanceof Number && (indexOfDecimalSeparator = valueLabel.lastIndexOf(decimalSeparator = (decimalFormatSymbols = DecimalFormatSymbols.getInstance()).getDecimalSeparator())) != -1) {
            valueLabel = valueLabel.substring(0, indexOfDecimalSeparator) + "<span class=\"decimal\">" + valueLabel.substring(indexOfDecimalSeparator) + "</span>";
        }
        return valueLabel;
    }

    public void emptyHeader(CrosstabDimension verticalDimension, CrosstabDimension horizontalDimension) {
        this.sb.append("<td class=\"empty\"></td>");
    }

    public HtmlFragment getResult() {
        this.htmlFragtment.addBodyElement(this.sb.toString());
        return this.htmlFragtment;
    }
}

