/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.datacleaner.api.Description;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RendererPrecedence;
import org.datacleaner.result.ListResult;
import org.datacleaner.result.html.HtmlFragment;
import org.datacleaner.result.html.SimpleHtmlFragment;
import org.datacleaner.result.renderer.HtmlRenderingFormat;
import org.datacleaner.result.renderer.SectionHeaderBodyElement;
import org.datacleaner.result.renderer.TableBodyElement;
import org.datacleaner.util.ReflectionUtils;

@RendererBean(value=HtmlRenderingFormat.class)
public class ListResultHtmlRenderer
implements Renderer<ListResult<?>, HtmlFragment> {
    public RendererPrecedence getPrecedence(ListResult<?> renderable) {
        return RendererPrecedence.LOW;
    }

    public HtmlFragment render(ListResult<?> result) {
        SimpleHtmlFragment htmlFragment = new SimpleHtmlFragment();
        List values = result.getValues();
        int rowCount = values.size();
        DefaultTableModel tableModel = new DefaultTableModel(rowCount, 1);
        for (int i = 0; i < rowCount; ++i) {
            tableModel.setValueAt(values.get(i), i, 0);
        }
        Description description = (Description)ReflectionUtils.getAnnotation(result.getClass(), Description.class);
        String descriptionText = description != null ? description.value() : "Values";
        htmlFragment.addBodyElement(new SectionHeaderBodyElement(descriptionText + " (" + rowCount + ")"));
        if (rowCount == 0) {
            htmlFragment.addBodyElement("<p>No records to display.</p>");
        } else {
            htmlFragment.addBodyElement(new TableBodyElement(tableModel, "annotatedRowsTable", new int[0]));
        }
        return htmlFragment;
    }
}

