/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import javax.swing.table.TableModel;
import org.apache.commons.lang.ArrayUtils;
import org.datacleaner.result.html.BodyElement;
import org.datacleaner.result.html.HtmlRenderingContext;
import org.datacleaner.util.LabelUtils;

public class TableBodyElement
implements BodyElement {
    private final TableModel _tableModel;
    private final String _tableClassName;
    private final int[] _highlightedColumns;

    public TableBodyElement(TableModel tableModel, String tableClassName, int[] highlightedColumns) {
        this._tableModel = tableModel;
        this._tableClassName = tableClassName;
        this._highlightedColumns = highlightedColumns;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public int[] getHighlightedColumns() {
        return this._highlightedColumns;
    }

    public String getTableClassName() {
        return this._tableClassName;
    }

    @Override
    public String toHtml(HtmlRenderingContext context) {
        int columnCount = this._tableModel.getColumnCount();
        StringBuilder sb = new StringBuilder();
        if (this._tableClassName == null) {
            sb.append("<table>");
        } else {
            sb.append("<table class=\"" + this.getTableClassName() + "\">");
        }
        int rowNumber = 0;
        sb.append("<tr class=\"" + (++rowNumber % 2 == 0 ? "even" : "odd") + "\">");
        for (int col = 0; col < columnCount; ++col) {
            String columnName = this._tableModel.getColumnName(col);
            sb.append("<th>");
            sb.append(this.getHeaderValue(context, col, columnName));
            sb.append("</th>");
        }
        sb.append("</tr>");
        int rowCount = this._tableModel.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            sb.append("<tr class=\"" + (++rowNumber % 2 == 0 ? "even" : "odd") + "\">");
            for (int col = 0; col < columnCount; ++col) {
                Object value = this._tableModel.getValueAt(row, col);
                String cellClass = this.getCellClass(context, row, col);
                if (cellClass == null) {
                    sb.append("<td>");
                } else {
                    sb.append("<td class=\"" + cellClass + "\">");
                }
                sb.append(this.getCellValue(context, row, col, value));
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    protected String getHeaderValue(HtmlRenderingContext context, int col, String columnName) {
        return context.escapeHtml(columnName);
    }

    protected String getCellClass(HtmlRenderingContext context, int row, int col) {
        if (ArrayUtils.indexOf((int[])this._highlightedColumns, (int)col) == -1) {
            return null;
        }
        return "highlighted";
    }

    protected String getCellValue(HtmlRenderingContext context, int row, int col, Object value) {
        String stringValue = LabelUtils.getValueLabel((Object)value);
        String result = context.escapeHtml(stringValue);
        return result;
    }
}

