/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.http;

import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Close;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.NumberProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.StringProperty;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.ImproveSuperCategory;
import org.datacleaner.components.categories.ReferenceDataCategory;
import org.datacleaner.components.http.HttpMethod;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.ws.PooledServiceSession;
import org.datacleaner.util.ws.ServiceResult;

@Named(value="HTTP request")
@Categorized(value={ReferenceDataCategory.class}, superCategory=ImproveSuperCategory.class)
@Description(value="Sends a HTTP request for each record and retrieves the response as transformation output.\nFor each request you can have dynamic elements in the URL or in the request body that is sent. Provide variable names that are unique to the URL and request body and reference them there. For instance:\n<table><tr><td>URL:</td><td>http://www.google.com/?q=${term}</td></tr><tr><td>Input:</td><td>column1</td></tr><tr><td>Variable:</td><td>${term}</td></tr></table>")
public class HttpRequestTransformer
implements Transformer {
    public static final String PROPERTY_INPUT_COLUMNS = "Input";
    public static final String PROPERTY_VARIABLE_NAMES = "Variable names";
    private static final String PROPERTY_URL = "URL";
    @Inject
    @Configured(value="URL", order=1)
    @Description(value="The URL to invoke. The URL will be pre-processed by replacing any variable names in it with the corresponding dynamic values.")
    String url = "http://";
    @Inject
    @Configured(order=2)
    HttpMethod method = HttpMethod.POST;
    @Inject
    @Configured(value="Input", order=3)
    InputColumn<?>[] input;
    @Inject
    @Configured(value="Variable names", order=4)
    @MappedProperty(value="Input")
    String[] variableNames;
    @Inject
    @Configured(order=5)
    @StringProperty(multiline=true, emptyString=true)
    @Description(value="The body of the request to invoke. The request body will be pre-processed by replacing any variable names in it with the corresponding dynamic values.")
    String requestBody = "";
    @Inject
    @Configured(required=false, order=100)
    Map<String, String> headers;
    @Inject
    @Configured(required=false, order=101)
    String charset = HTTP.DEF_CONTENT_CHARSET.name();
    @Inject
    @Configured(required=false, order=150)
    @NumberProperty(negative=false, zero=false, positive=true)
    @Description(value="The maximum number of requests that may be fired at the same time.\nHigher values may provide better throughput while it may also add load to the HTTP server.")
    int maxConcurrentRequests = 20;
    private CloseableHttpClient _httpClient;
    private PooledServiceSession<Object[]> _session;

    @Initialize
    public void init() {
        this._httpClient = HttpClients.createSystem();
        this._session = new PooledServiceSession(this.maxConcurrentRequests);
    }

    @Close
    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._httpClient, this._session});
    }

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[]{"Response status code", "Response body"};
        Class[] columnTypes = new Class[]{Integer.class, String.class};
        return new OutputColumns(columnNames, columnTypes);
    }

    public Object[] transform(InputRow inputRow) {
        ServiceResult result;
        final Charset usedCharset = Charset.forName(this.charset);
        String requestBody = this.applyVariablesToString(this.requestBody, inputRow);
        String url = this.applyVariablesToString(this.url, inputRow);
        final HttpUriRequest request = this.method.createRequest(url);
        if (!Strings.isNullOrEmpty((String)requestBody) && request instanceof HttpEntityEnclosingRequest) {
            StringEntity entity = new StringEntity(requestBody, usedCharset);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)entity);
        }
        if (this.headers != null) {
            Set<Map.Entry<String, String>> entries = this.headers.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!(result = this._session.invokeService((Callable)new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                CloseableHttpResponse response = HttpRequestTransformer.this._httpClient.execute(request);
                int statusCode = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)usedCharset);
                return new Object[]{statusCode, body};
            }
        })).isSuccesfull()) {
            Throwable error = result.getError();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RuntimeException(error);
        }
        return (Object[])result.getResponse();
    }

    protected String applyVariablesToString(String str, InputRow inputRow) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        String result = str;
        List values = inputRow.getValues(this.input);
        for (int i = 0; i < this.input.length; ++i) {
            Object value = values.get(i);
            String valueStr = value == null ? "" : value.toString();
            result = StringUtils.replaceAll((String)result, (String)this.variableNames[i], (String)valueStr);
        }
        return result;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public void setInputAndVariables(InputColumn<?>[] input, String[] variableNames) {
        this.input = input;
        this.variableNames = variableNames;
    }
}

