/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.script;

import java.lang.reflect.Type;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.util.ReflectionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class JavaScriptUtils {
    private JavaScriptUtils() {
    }

    public static void addToScope(Scriptable scope, Object object, String ... names) {
        Object jsObject = Context.javaToJS((Object)object, (Scriptable)scope);
        for (String name : names) {
            name = name.replaceAll(" ", "_");
            ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)jsObject);
        }
    }

    public static void addToScope(Scriptable scope, InputRow inputRow, InputColumn<?>[] columns, String arrayName) {
        NativeArray values = new NativeArray((long)(columns.length * 2));
        for (int i = 0; i < columns.length; ++i) {
            InputColumn<?> column = columns[i];
            Object value = inputRow.getValue(column);
            if (value != null) {
                Class dataType = column.getDataType();
                if (ReflectionUtils.isNumber((Type)dataType)) {
                    value = Context.toNumber((Object)value);
                } else if (ReflectionUtils.isBoolean((Type)dataType)) {
                    value = Context.toBoolean((Object)value);
                }
            }
            values.put(i, (Scriptable)values, value);
            values.put(column.getName(), (Scriptable)values, value);
            JavaScriptUtils.addToScope(scope, value, column.getName(), column.getName().toLowerCase(), column.getName().toUpperCase());
        }
        JavaScriptUtils.addToScope(scope, values, arrayName);
    }
}

