/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.monitor.server.wizard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.monitor.server.wizard.AbstractJdbcDatastoreWizardSession;
import org.eobjects.datacleaner.monitor.server.wizard.DatastoreNameAndDescriptionWizardPage;
import org.eobjects.datacleaner.monitor.shared.model.DCUserInputException;
import org.eobjects.datacleaner.monitor.wizard.WizardPageController;
import org.eobjects.datacleaner.monitor.wizard.common.AbstractFreemarkerWizardPage;

abstract class JdbcConnectionInformationWizardPage
extends AbstractFreemarkerWizardPage {
    private final AbstractJdbcDatastoreWizardSession _session;
    private final String _templateUrl;

    public JdbcConnectionInformationWizardPage(AbstractJdbcDatastoreWizardSession session, String templateUrl) {
        this._session = session;
        this._templateUrl = templateUrl;
    }

    public WizardPageController nextPageController(Map<String, List<String>> formParameters) throws DCUserInputException {
        String url = JdbcConnectionInformationWizardPage.getString(formParameters, (String)"url");
        if (StringUtils.isNullOrEmpty((String)url)) {
            throw new DCUserInputException("Connection string / URL cannot be empty");
        }
        this._session.setUrl(url);
        String username = JdbcConnectionInformationWizardPage.getString(formParameters, (String)"username");
        String password = JdbcConnectionInformationWizardPage.getString(formParameters, (String)"password");
        this._session.setCredentials(username, password);
        return new DatastoreNameAndDescriptionWizardPage(this._session.getWizardContext(), this.getPageIndex() + 1){

            protected WizardPageController nextPageController(String name, String description) {
                JdbcConnectionInformationWizardPage.this._session.setDescription(description);
                JdbcConnectionInformationWizardPage.this._session.setName(name);
                return null;
            }
        };
    }

    protected String getTemplateFilename() {
        return "JdbcConnectionInformationWizardPage.html";
    }

    protected Map<String, Object> getFormModel() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templateUrl", this._templateUrl);
        return map;
    }
}

