/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.monitor.server.wizard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.monitor.server.wizard.GenericJdbcDatastoreWizardSession;
import org.eobjects.datacleaner.monitor.server.wizard.JdbcConnectionInformationWizardPage;
import org.eobjects.datacleaner.monitor.shared.model.DCUserInputException;
import org.eobjects.datacleaner.monitor.wizard.WizardPageController;
import org.eobjects.datacleaner.monitor.wizard.common.AbstractFreemarkerWizardPage;

final class JdbcDriverWizardPage
extends AbstractFreemarkerWizardPage {
    private final GenericJdbcDatastoreWizardSession _session;

    public JdbcDriverWizardPage(GenericJdbcDatastoreWizardSession session) {
        this._session = session;
    }

    public Integer getPageIndex() {
        return 0;
    }

    public WizardPageController nextPageController(Map<String, List<String>> formParameters) throws DCUserInputException {
        String[] connectionUrlTemplates;
        String driverClassName = formParameters.get("driverClassName").get(0);
        this._session.setDriverClassName(driverClassName);
        DatabaseDriverDescriptor driver = DatabaseDriverCatalog.getDatabaseDriverByDriverClassName((String)driverClassName);
        String templateUrl = driver == null ? "jdbc:<vendor>://<hostname>/<database>" : ((connectionUrlTemplates = driver.getConnectionUrlTemplates()) == null || connectionUrlTemplates.length == 0 ? "jdbc:<vendor>://<hostname>/<database>" : connectionUrlTemplates[0]);
        return new JdbcConnectionInformationWizardPage(this._session, templateUrl){

            public Integer getPageIndex() {
                return JdbcDriverWizardPage.this.getPageIndex() + 1;
            }
        };
    }

    protected String getTemplateFilename() {
        return "JdbcDriverWizardPage.html";
    }

    protected Map<String, Object> getFormModel() {
        return new HashMap<String, Object>();
    }
}

