/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.monitor.server.wizard;

import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.monitor.server.wizard.JdbcDatastoreWizardSession;
import org.eobjects.datacleaner.monitor.wizard.datastore.DatastoreWizard;
import org.eobjects.datacleaner.monitor.wizard.datastore.DatastoreWizardContext;
import org.eobjects.datacleaner.monitor.wizard.datastore.DatastoreWizardSession;
import org.springframework.stereotype.Component;

@Component
public class SQLServerDatastoreWizard
implements DatastoreWizard {
    public String getDisplayName() {
        return "Microsoft SQL server";
    }

    public int getExpectedPageCount() {
        return 2;
    }

    public DatastoreWizardSession start(DatastoreWizardContext context) {
        String url = "jdbc:jtds:sqlserver://<hostname>/<database>;useUnicode=true;characterEncoding=UTF-8";
        return new JdbcDatastoreWizardSession(context, "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://<hostname>/<database>;useUnicode=true;characterEncoding=UTF-8");
    }

    public boolean isApplicableTo(DatastoreWizardContext context) {
        DatabaseDriverCatalog catalog = new DatabaseDriverCatalog(null);
        boolean installed = catalog.isInstalled("Microsoft SQL Server (JTDS)");
        return installed;
    }
}

