/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eobjects.analyzer.beans.convert.ConvertToNumberTransformer;
import org.eobjects.datacleaner.lucene.FileSystemSearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.SearchIndexListener;
import org.eobjects.datacleaner.user.UserPreferences;

public class DefaultSearchIndexCatalog
implements SearchIndexCatalog {
    private static final String PROPERTY_PREFIX = "datacleaner.lucene.";
    private final List<SearchIndexListener> _listeners;
    private final Map<String, SearchIndex> _searchIndices;
    private final Map<String, String> _properties;

    public DefaultSearchIndexCatalog(UserPreferences userPreferences) {
        this(userPreferences.getAdditionalProperties());
    }

    protected DefaultSearchIndexCatalog(Map<String, String> properties) {
        this._properties = properties;
        this._searchIndices = new TreeMap<String, SearchIndex>();
        this._listeners = new ArrayList<SearchIndexListener>(3);
        this.initialize();
    }

    protected void initialize() {
        Number count = this.getNumber("datacleaner.lucene.index_count");
        if (count == null) {
            return;
        }
        for (int i = 0; i < count.intValue(); ++i) {
            SearchIndex searchIndex = this.initializeSearchIndex(i);
            this._searchIndices.put(searchIndex.getName(), searchIndex);
        }
    }

    private SearchIndex initializeSearchIndex(int i) {
        String name = this.getString(PROPERTY_PREFIX + i + ".name");
        String description = this.getString(PROPERTY_PREFIX + i + ".description");
        String path = this.getString(PROPERTY_PREFIX + i + ".path");
        File directory = new File(path);
        FileSystemSearchIndex searchIndex = new FileSystemSearchIndex(name, directory);
        searchIndex.setDescription(description);
        return searchIndex;
    }

    private String getString(String key) {
        return this._properties.get(key);
    }

    private Number getNumber(String key) {
        String value = this.getString(key);
        return ConvertToNumberTransformer.transformValue((Object)value);
    }

    private void setString(String key, String value) {
        this._properties.put(key, value);
    }

    @Override
    public String[] getSearchIndexNames() {
        return this._searchIndices.keySet().toArray(new String[this._searchIndices.size()]);
    }

    @Override
    public SearchIndex getSearchIndex(String name) {
        if (name == null) {
            return null;
        }
        return this._searchIndices.get(name);
    }

    @Override
    public void addSearchIndex(SearchIndex searchIndex) {
        this._searchIndices.put(searchIndex.getName(), searchIndex);
        this.updateMap();
        for (SearchIndexListener listener : this._listeners) {
            listener.onAdd(searchIndex);
        }
    }

    @Override
    public void removeSearchIndex(SearchIndex searchIndex) {
        this._searchIndices.remove(searchIndex.getName());
        this.updateMap();
        for (SearchIndexListener listener : this._listeners) {
            listener.onRemove(searchIndex);
        }
    }

    private void updateMap() {
        this.setString("datacleaner.lucene.index_count", this._searchIndices.size() + "");
        int i = 0;
        for (SearchIndex searchIndex : this._searchIndices.values()) {
            FileSystemSearchIndex fileSystemSearchIndex = (FileSystemSearchIndex)searchIndex;
            this.setString(PROPERTY_PREFIX + i + ".name", searchIndex.getName());
            this.setString(PROPERTY_PREFIX + i + ".description", searchIndex.getDescription());
            this.setString(PROPERTY_PREFIX + i + ".path", fileSystemSearchIndex.getFile().getPath());
            ++i;
        }
    }

    @Override
    public void addListener(SearchIndexListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(SearchIndexListener listener) {
        this._listeners.remove(listener);
    }
}

